/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.Set;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IPlayerModel;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.armature.JointTransformModifier;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFightModelHolder;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightContext;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightTransformProvider;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinVisibilityTransformer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EpicFlightWardrobeHandler {
    private static final OpenMatrix3f CONVERTER_MAT3 = new OpenMatrix3f();
    private static final OpenMatrix4f CONVERTER_MAT4 = new OpenMatrix4f();
    private static final SkinVisibilityTransformer<IPlayerModel> VISIBILITY_TRANSFORMER = new SkinVisibilityTransformer();
    private static final EpicFlightContext context = new EpicFlightContext();

    public static void onSetup() {
        ModConfig.Client.enablePartSubdivide = true;
        SkinVisibilityTransformer.setupHumanoidModel(VISIBILITY_TRANSFORMER);
        SkinVisibilityTransformer.setupPlayerModel(VISIBILITY_TRANSFORMER);
    }

    public static void onRenderLivingPre(LivingEntity entity, float partialTicks, int packedLight, MatrixStack poseStack, IRenderTypeBuffer buffers, LivingRenderer<?, ?> entityRenderer, boolean isFirstPersonRenderer, EpicFlightTransformProvider transformProvider) {
        Object model = ModelHolder.ofNullable(entityRenderer.func_217764_d());
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        Set<ISkinPartType> overrideParts = null;
        if (isFirstPersonRenderer) {
            overrideParts = Collections.singleton(SkinPartTypes.BIPPED_HEAD);
        }
        model.setAssociatedObject((EpicFlightTransformProvider)transformProvider, EpicFlightTransformProvider.KEY);
        EpicFlightWardrobeHandler.context.overrideParts = overrideParts;
        EpicFlightWardrobeHandler.context.overridePostStack = ABI.copy(poseStack);
        EpicFlightWardrobeHandler.context.overrideTransformModifier = model.getAssociatedObject(JointTransformModifier.EPICFIGHT);
        EpicFlightWardrobeHandler.context.isLimitLimbs = false;
        renderData.epicFlightContext = context;
        SkinRendererManager.getInstance().willRender(entity, (Model)entityRenderer.func_217764_d(), (EntityRenderer<?>)entityRenderer, renderData, () -> SkinRenderContext.alloc(renderData, packedLight, partialTicks, poseStack, buffers));
    }

    public static void onRenderLivingPost(LivingEntity entity, float partialTicks, int packedLight, MatrixStack poseStack, IRenderTypeBuffer buffers, LivingRenderer<?, ?> entityRenderer) {
        Object model = ModelHolder.ofNullable(entityRenderer.func_217764_d());
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        model.setAssociatedObject(null, EpicFlightTransformProvider.KEY);
        VISIBILITY_TRANSFORMER.didRender(null, renderData.getOverriddenManager());
        EpicFlightWardrobeHandler.context.overrideParts = null;
        EpicFlightWardrobeHandler.context.overridePostStack = null;
        EpicFlightWardrobeHandler.context.overrideTransformModifier = null;
        EpicFlightWardrobeHandler.context.isLimitLimbs = true;
        renderData.epicFlightContext = null;
        SkinRendererManager.getInstance().didRender(entity, (Model)entityRenderer.func_217764_d(), (EntityRenderer<?>)entityRenderer, renderData, () -> SkinRenderContext.alloc(renderData, packedLight, partialTicks, poseStack, buffers));
    }

    public static void onPrepareModel(LivingEntity entity, Object animatedModel) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        IModel model = EpicFightModelHolder.of(animatedModel);
        if (model instanceof IPlayerModel) {
            VISIBILITY_TRANSFORMER.willRender((IPlayerModel)model, renderData.getOverriddenManager());
        }
    }

    public static OpenMatrix4f convertPoseMatrix(FloatBuffer buffer) {
        CONVERTER_MAT4.load(buffer);
        return CONVERTER_MAT4;
    }

    public static OpenMatrix3f convertNormalMatrix(FloatBuffer buffer) {
        if (buffer.remaining() == 9) {
            CONVERTER_MAT3.load(buffer);
        } else {
            CONVERTER_MAT3.import44(buffer);
        }
        return CONVERTER_MAT3;
    }
}

