/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import extensions.net.minecraft.world.item.ItemStack.ABI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;

public final class SkinUtils {
    public static final float[][][] FACE_UVS = new float[][][]{new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}};
    public static final float[][][] FACE_VERTEXES = new float[][][]{new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -1.0f}}, new float[][]{{1.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 1.0f}}, new float[][]{{1.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f}, {1.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}}};

    private SkinUtils() {
    }

    public static float[][] getRenderUVs(Direction direction) {
        return FACE_UVS[direction.func_176745_a()];
    }

    public static float[][] getRenderVertexes(Direction direction) {
        return FACE_VERTEXES[direction.func_176745_a()];
    }

    public static boolean shouldKeepWardrobe(PlayerEntity entity) {
        if (entity.func_175149_v()) {
            return true;
        }
        int keep = ModConfig.Common.prefersWardrobeDropOnDeath;
        if (keep == 1) {
            return true;
        }
        if (keep == 2) {
            return false;
        }
        return PropertyProvider.getLevel((Entity)entity).func_82736_K().func_223586_b(GameRules.field_223600_c);
    }

    public static void dropAll(PlayerEntity player) {
        if (SkinUtils.shouldKeepWardrobe(player)) {
            return;
        }
        SkinWardrobe oldWardrobe = SkinWardrobe.of((Entity)player);
        if (oldWardrobe != null) {
            oldWardrobe.dropAll(arg_0 -> ((PlayerEntity)player).func_199701_a_(arg_0));
        }
    }

    public static void giveTo(ItemStack itemStack, PlayerEntity player) {
        boolean flag = extensions.net.minecraft.world.entity.player.Player.PropertyProvider.getInventory(player).func_70441_a(itemStack);
        if (flag && itemStack.func_190926_b()) {
            itemStack.func_190920_e(1);
            ItemEntity itemEntity1 = player.func_71019_a(itemStack, false);
            if (itemEntity1 != null) {
                itemEntity1.func_174870_v();
            }
            PropertyProvider.getLevel((Entity)player).func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.field_71069_bz.func_75142_b();
        } else {
            ItemEntity itemEntity = player.func_71019_a(itemStack, false);
            if (itemEntity != null) {
                itemEntity.func_174868_q();
                itemEntity.func_200216_c(player.func_110124_au());
            }
        }
    }

    public static void copySkinFromOwner(Entity entity) {
        ProjectileEntity projectile = ObjectUtils.safeCast(entity, ProjectileEntity.class);
        if (projectile == null) {
            return;
        }
        Entity owner = projectile.func_234616_v_();
        if (entity instanceof TridentEntity) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.TRIDENT, 0);
            return;
        }
        if (entity instanceof AbstractArrowEntity) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.BOW, 0);
            return;
        }
    }

    public static void copySkin(Entity src, Entity dest, SkinSlotType slotType, int index) {
        ItemStack itemStack = SkinUtils.getSkin(src, slotType, index);
        if (itemStack.func_190926_b()) {
            return;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(dest);
        if (wardrobe != null) {
            wardrobe.setItem(slotType, index, itemStack.func_77946_l());
            wardrobe.broadcast();
        }
    }

    public static Skin copySkin(Skin skin) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SkinFileStreamUtils.saveSkinToStream(outputStream, skin);
        byte[] skinData = outputStream.toByteArray();
        Skin skinCopy = SkinFileStreamUtils.loadSkinFromStream(new ByteArrayInputStream(skinData));
        return skinCopy;
    }

    public static ItemStack getSkin(Entity entity, SkinSlotType slotType, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (entity instanceof LivingEntity) {
            itemStack = SkinUtils.getUsingItem((LivingEntity)entity);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (Objects.equals(slotType.getSkinType(), descriptor.getType())) {
            return itemStack;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            ItemStack itemStack1 = wardrobe.getItem(slotType, index);
            descriptor = SkinDescriptor.of(itemStack1);
            if (Objects.equals(slotType.getSkinType(), descriptor.getType())) {
                return itemStack1;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getUsingItem(LivingEntity entity) {
        ItemStack itemStack = entity.func_184607_cu();
        if (!itemStack.func_190926_b()) {
            return itemStack;
        }
        itemStack = entity.func_184614_ca();
        if (ABI.is(itemStack, Items.field_222114_py) && CrossbowItem.func_220012_d((ItemStack)itemStack)) {
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    private static int getSkinIndex(String partIndexProp, Skin skin, int partIndex) {
        String[] split = partIndexProp.split(":");
        for (int i = 0; i < split.length; ++i) {
            int count = Integer.parseInt(split[i]);
            if (partIndex >= count) continue;
            return i;
        }
        return -1;
    }

    public static VoxelShape apply(VoxelShape shape, OpenMatrix4f matrix) {
        float minX = (float)shape.func_197762_b(Direction.Axis.X);
        float minY = (float)shape.func_197762_b(Direction.Axis.Y);
        float minZ = (float)shape.func_197762_b(Direction.Axis.Z);
        float maxX = (float)shape.func_197758_c(Direction.Axis.X);
        float maxY = (float)shape.func_197758_c(Direction.Axis.Y);
        float maxZ = (float)shape.func_197758_c(Direction.Axis.Z);
        Vector4f[] points = new Vector4f[]{new Vector4f(minX, minY, minZ, 1.0f), new Vector4f(maxX, minY, minZ, 1.0f), new Vector4f(maxX, maxY, minZ, 1.0f), new Vector4f(minX, maxY, minZ, 1.0f), new Vector4f(minX, minY, maxZ, 1.0f), new Vector4f(maxX, minY, maxZ, 1.0f), new Vector4f(maxX, maxY, maxZ, 1.0f), new Vector4f(minX, maxY, maxZ, 1.0f)};
        boolean isReset = false;
        for (Vector4f point : points) {
            point.transform(matrix);
            if (isReset) {
                minX = Math.min(minX, point.x());
                minY = Math.min(minY, point.y());
                minZ = Math.min(minZ, point.z());
                maxX = Math.max(maxX, point.x());
                maxY = Math.max(maxY, point.y());
                maxZ = Math.max(maxZ, point.z());
                continue;
            }
            minX = point.x();
            minY = point.y();
            minZ = point.z();
            maxX = point.x();
            maxY = point.y();
            maxZ = point.z();
            isReset = true;
        }
        return VoxelShapes.func_197873_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }
}

