/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.texture;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.math.ITexturePos;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.utils.texture.PlayerTextureModel;
import moe.plushie.armourers_workshop.utils.texture.SkyBox;

public class SkinPaintData {
    public static final int TEXTURE_OLD_WIDTH = 64;
    public static final int TEXTURE_OLD_HEIGHT = 32;
    public static final int TEXTURE_WIDTH = 64;
    public static final int TEXTURE_HEIGHT = 64;
    private final int width;
    private final int height;
    private final int[] data;

    public SkinPaintData(int width, int height) {
        this.data = new int[width * height];
        this.width = width;
        this.height = height;
    }

    public SkinPaintData(int width, int height, int[] data) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    public static SkinPaintData v1() {
        return new SkinPaintData(64, 32);
    }

    public static SkinPaintData v2() {
        return new SkinPaintData(64, 64);
    }

    public SkinPaintData clone() {
        SkinPaintData paintData = new SkinPaintData(this.width, this.height);
        System.arraycopy(this.data, 0, paintData.data, 0, this.data.length);
        return paintData;
    }

    public void copyFrom(SkinPaintData paintData) {
        if (this.width != paintData.getWidth()) {
            return;
        }
        if (this.height == paintData.getHeight()) {
            System.arraycopy(paintData.getData(), 0, this.data, 0, this.data.length);
            return;
        }
        System.arraycopy(paintData.getData(), 0, this.data, 0, this.width * Math.min(this.height, paintData.getHeight()));
        if (this.height <= 32) {
            return;
        }
        PlayerTextureModel source = PlayerTextureModel.of(paintData.getWidth(), paintData.getHeight(), false);
        PlayerTextureModel destination = PlayerTextureModel.of(this.getWidth(), this.getHeight(), false);
        source.forEach((partType, sourceBox) -> {
            SkyBox destinationBox = destination.get((ISkinPartType)partType);
            if (sourceBox.equals(destinationBox) || destinationBox == null) {
                return;
            }
            ArrayList sourceTextures = new ArrayList(0);
            sourceBox.forEach((texture, x, y, z, dir) -> sourceTextures.add(texture));
            destinationBox.forEach((texture, x, y, z, dir) -> {
                if (!sourceTextures.isEmpty()) {
                    int color = paintData.getColor((ITexturePos)sourceTextures.remove(0));
                    this.setColor(texture, color);
                }
            });
        });
    }

    public int getColor(ITexturePos point) {
        return this.getColor(point.getU(), point.getV());
    }

    public void setColor(ITexturePos point, int color) {
        this.setColor(point.getU(), point.getV(), color);
    }

    public int getColor(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        return this.data[x + y * this.width];
    }

    public void setColor(int x, int y, IPaintColor paintColor) {
        this.setColor(x, y, paintColor.getRawValue());
    }

    public void setColor(int x, int y, int color) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        this.data[x + y * this.width] = color;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getData() {
        return this.data;
    }
}

