/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render;

import moe.plushie.armourers_workshop.api.common.IPoint3D;
import moe.plushie.armourers_workshop.api.common.IRectangle3D;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.type.block.SkinBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class ArmourerRenderHelper {
    private static final ResourceLocation guideImage = new ResourceLocation("armourers_workshop".toLowerCase(), "textures/blocks/guide.png");

    public static void renderBuildingGuide(ISkinType skinType, float scale, SkinProperties skinProps, boolean showHelper) {
        for (int i = 0; i < skinType.getSkinParts().size(); ++i) {
            ISkinPartType skinPart = skinType.getSkinParts().get(i);
            if (skinPart.isModelOverridden(skinProps)) continue;
            IPoint3D partOffset = skinPart.getOffset();
            GlStateManager.func_179109_b((float)((float)partOffset.getX() * scale), (float)((float)partOffset.getY() * scale), (float)((float)partOffset.getZ() * scale));
            skinPart.renderBuildingGuide(scale, skinProps, showHelper);
            GlStateManager.func_179109_b((float)((float)(-partOffset.getX()) * scale), (float)((float)(-partOffset.getY()) * scale), (float)((float)(-partOffset.getZ()) * scale));
        }
    }

    public static void renderBuildingGrid(ISkinType skinType, float scale, boolean showGuides, SkinProperties skinProps, boolean multiblock) {
        for (int i = 0; i < skinType.getSkinParts().size(); ++i) {
            ISkinPartType skinPartType = skinType.getSkinParts().get(i);
            IPoint3D partOffset = skinPartType.getOffset();
            GlStateManager.func_179109_b((float)((float)partOffset.getX() * scale), (float)((float)partOffset.getY() * scale), (float)((float)partOffset.getZ() * scale));
            if (skinType == SkinTypeRegistry.skinBlock) {
                if (skinPartType.getPartName().equals("multiblock") & multiblock) {
                    ArmourerRenderHelper.renderBuildingGrid(((SkinBlock)SkinTypeRegistry.skinBlock).partBase, scale, showGuides, skinProps, 1.0f, 1.0f, 0.0f, 0.2f);
                    GL11.glPolygonOffset((float)6.0f, (float)6.0f);
                    ArmourerRenderHelper.renderBuildingGrid(skinPartType, scale, showGuides, skinProps, 0.5f, 0.5f, 0.5f, 0.25f);
                } else if (skinPartType.getPartName().equals("base") & !multiblock) {
                    ArmourerRenderHelper.renderBuildingGrid(skinPartType, scale, showGuides, skinProps, 0.5f, 0.5f, 0.5f, 0.25f);
                }
            } else {
                ArmourerRenderHelper.renderBuildingGrid(skinPartType, scale, showGuides, skinProps, 0.5f, 0.5f, 0.5f, 0.25f);
            }
            GlStateManager.func_179109_b((float)((float)(-partOffset.getX()) * scale), (float)((float)(-partOffset.getY()) * scale), (float)((float)(-partOffset.getZ()) * scale));
        }
    }

    public static void renderBuildingGrid(ISkinPartType skinPartType, float scale, boolean showGuides, SkinProperties skinProps, float r, float g, float b, float a) {
        GlStateManager.func_179109_b((float)0.0f, (float)((float)skinPartType.getBuildingSpace().getY() * scale), (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        ArmourerRenderHelper.renderGuidePart(skinPartType, scale, showGuides, skinProps, r, g, b, a);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)((float)(-skinPartType.getBuildingSpace().getY()) * scale), (float)0.0f);
    }

    private static void renderGuidePart(ISkinPartType part, float scale, boolean showGuides, SkinProperties skinProps, float r, float g, float b, float a) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(guideImage);
        IRectangle3D buildRec = part.getBuildingSpace();
        IRectangle3D guideRec = part.getGuideSpace();
        GlStateManager.func_179094_E();
        if (showGuides) {
            ArmourerRenderHelper.renderGuideBox(buildRec.getX(), buildRec.getY(), buildRec.getZ(), buildRec.getWidth(), buildRec.getHeight(), buildRec.getDepth(), scale, r, g, b, a);
            ArmourerRenderHelper.renderGuideBox(-0.5, -0.5, -0.5, 1, 1, 1, scale, 0.0f, 1.0f, 0.0f, 0.5f);
        }
        if (ConfigHandlerClient.showArmourerDebugRender) {
            ArmourerRenderHelper.renderGuideBox(guideRec.getX(), guideRec.getY(), guideRec.getZ(), guideRec.getWidth(), guideRec.getHeight(), guideRec.getDepth(), scale, 1.0f, 0.0f, 0.0f, 0.25f);
        }
        if (part.isModelOverridden(skinProps)) {
            ArmourerRenderHelper.renderGuideBox(guideRec.getX(), guideRec.getY(), guideRec.getZ(), guideRec.getWidth(), guideRec.getHeight(), guideRec.getDepth(), scale, 0.0f, 0.0f, 1.0f, 0.25f);
        }
        GlStateManager.func_179121_F();
    }

    private static void renderGuideBox(double x, double y, double z, int width, int height, int depth, float scale, float r, float g, float b, float a) {
        ArmourerRenderHelper.renderGuideFace(EnumFacing.DOWN, x, y, z, width, depth, scale, r, g, b, a);
        ArmourerRenderHelper.renderGuideFace(EnumFacing.UP, x, y + (double)height, z, width, depth, scale, r, g, b, a);
        ArmourerRenderHelper.renderGuideFace(EnumFacing.EAST, x + (double)width, y, z, depth, height, scale, r, g, b, a);
        ArmourerRenderHelper.renderGuideFace(EnumFacing.WEST, x, y, z, depth, height, scale, r, g, b, a);
        ArmourerRenderHelper.renderGuideFace(EnumFacing.NORTH, x, y, z, width, height, scale, r, g, b, a);
        ArmourerRenderHelper.renderGuideFace(EnumFacing.SOUTH, x, y, z + (double)depth, width, height, scale, r, g, b, a);
    }

    private static void renderGuideFace(EnumFacing dir, double x, double y, double z, double sizeX, double sizeY, float scale, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        float scale1 = 0.999f;
        GlStateManager.func_179137_b((double)(x * (double)scale), (double)(y * (double)scale), (double)(z * (double)scale));
        switch (dir) {
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buff.func_181662_b(0.0, sizeY * (double)scale, 0.0).func_187315_a(sizeY, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buff.func_181662_b(sizeX * (double)scale, sizeY * (double)scale, 0.0).func_187315_a(sizeY, sizeX).func_181666_a(r, g, b, a).func_181675_d();
        buff.func_181662_b(sizeX * (double)scale, 0.0, 0.0).func_187315_a(0.0, sizeX).func_181666_a(r, g, b, a).func_181675_d();
        tess.func_78381_a();
        ModRenderHelper.disableAlphaBlend();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }
}

