/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.crafting;

import moe.plushie.armourers_workshop.common.addons.ModAddonManager;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.crafting.ItemSkinningRecipes;
import moe.plushie.armourers_workshop.common.crafting.ModItemRecipes;
import moe.plushie.armourers_workshop.common.handler.DollCraftingHandler;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="armourers_workshop")
public final class CraftingManager {
    public static void init() {
        if (!ConfigHandler.disableSkinningRecipes) {
            ItemSkinningRecipes.init();
        }
        new DollCraftingHandler();
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (!ConfigHandler.disableRecipes) {
            ModItemRecipes.init((IForgeRegistry<IRecipe>)event.getRegistry());
        }
    }

    public static void addShapelessRecipe(IForgeRegistry<IRecipe> iForgeRegistry, ItemStack result, Object[] recipe, ResourceLocation registryName) {
        iForgeRegistry.register(new ShapelessOreRecipe(null, result, recipe).setRegistryName(registryName));
    }

    public static void addShapelessRecipe(IForgeRegistry<IRecipe> iForgeRegistry, ItemStack result, Object[] recipe) {
        iForgeRegistry.register(new ShapelessOreRecipe(null, result, recipe).setRegistryName(result.func_77973_b().getRegistryName()));
    }

    public static void addShapedRecipe(IForgeRegistry<IRecipe> iForgeRegistry, ItemStack result, Object[] recipe, ResourceLocation registryName) {
        iForgeRegistry.register(new ShapedOreRecipe(null, result, recipe).setRegistryName(registryName));
    }

    public static void addShapedRecipe(IForgeRegistry<IRecipe> iForgeRegistry, ItemStack result, Object[] recipe) {
        iForgeRegistry.register(new ShapedOreRecipe(null, result, recipe).setRegistryName(result.func_77973_b().getRegistryName()));
    }

    public static void hideItemsInNEI() {
        CraftingManager.hideItemInNEI(new ItemStack(ModBlocks.BOUNDING_BOX, 1));
        CraftingManager.hideItemInNEI(new ItemStack(ModItems.ARMOUR_CONTAINER[0], 1));
        CraftingManager.hideItemInNEI(new ItemStack(ModItems.ARMOUR_CONTAINER[1], 1));
        CraftingManager.hideItemInNEI(new ItemStack(ModItems.ARMOUR_CONTAINER[2], 1));
        CraftingManager.hideItemInNEI(new ItemStack(ModItems.ARMOUR_CONTAINER[3], 1));
        CraftingManager.hideItemInNEI(new ItemStack(ModItems.SKIN, 1));
        CraftingManager.hideItemInNEI(new ItemStack(ModBlocks.SKINNABLE, 1));
        CraftingManager.hideItemInNEI(new ItemStack(ModBlocks.SKINNABLE_GLOWING, 1));
        CraftingManager.hideItemInNEI(new ItemStack(ModBlocks.SKINNABLE_CHILD, 1));
        CraftingManager.hideItemInNEI(new ItemStack(ModBlocks.SKINNABLE_CHILD_GLOWING, 1));
    }

    private static void hideItemInNEI(ItemStack stack) {
        ModAddonManager.addonNEI.hideItem(stack);
    }
}

