/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items;

import java.awt.Color;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPaintingTool;
import moe.plushie.armourers_workshop.api.common.painting.IPantable;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItem;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDyeBottle
extends AbstractModItem
implements IPaintingTool {
    public ItemDyeBottle() {
        super("dye-bottle");
        this.setSortPriority(11);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (player.func_70093_af() & state.func_177230_c() == ModBlocks.COLOUR_MIXER) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te != null && te instanceof IPantable && !worldIn.field_72995_K) {
                ItemStack stack = player.func_184586_b(hand);
                int colour = ((IPantable)te).getColour(0);
                IPaintType paintType = ((IPantable)te).getPaintType(0);
                this.setToolColour(stack, colour);
                this.setToolPaintType(stack, paintType);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_77636_d(ItemStack stack) {
        IPaintType paintType = PaintingHelper.getToolPaintType(stack);
        if (paintType != PaintTypeRegistry.PAINT_TYPE_NORMAL) {
            return true;
        }
        return super.func_77636_d(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.getToolHasColour(stack)) {
            Color c = new Color(this.getToolColour(stack));
            IPaintType paintType = this.getToolPaintType(stack);
            String hex = String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
            String colourText = TranslateUtils.translate("item.armourers_workshop:rollover.colour", c.getRGB());
            String hexText = TranslateUtils.translate("item.armourers_workshop:rollover.hex", hex);
            String paintText = TranslateUtils.translate("item.armourers_workshop:rollover.paintType", paintType.getLocalizedName());
            tooltip.add(colourText);
            tooltip.add(hexText);
            tooltip.add(paintText);
        } else {
            String emptyText = TranslateUtils.translate("item.armourers_workshop:rollover.empty");
            tooltip.add(emptyText);
        }
    }

    @Override
    public boolean getToolHasColour(ItemStack stack) {
        return PaintingHelper.getToolHasPaint(stack);
    }

    @Override
    public int getToolColour(ItemStack stack) {
        return PaintingHelper.getToolPaintColourRGB(stack);
    }

    @Override
    public void setToolColour(ItemStack stack, int colour) {
        PaintingHelper.setToolPaintColour(stack, colour);
    }

    @Override
    public void setToolPaintType(ItemStack stack, IPaintType paintType) {
        PaintingHelper.setToolPaint(stack, paintType);
    }

    @Override
    public IPaintType getToolPaintType(ItemStack stack) {
        return PaintingHelper.getToolPaintType(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (ItemDyeBottle.this.getToolHasColour(stack)) {
                    return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemDyeBottle.this.func_77658_a()), "inventory");
                }
                return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemDyeBottle.this.func_77658_a() + "-empty"), "inventory");
            }
        });
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a()), "inventory"), new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a() + "-empty"), "inventory")});
    }
}

