/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.world.undo;

import java.awt.Color;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class UndoData {
    public final int blockX;
    public final int blockY;
    public final int blockZ;
    public final int dimensionId;
    public final byte[] rgb;
    public final byte paintType;
    public final EnumFacing facing;

    public UndoData(int blockX, int blockY, int blockZ, int dimensionId, byte[] rgb, byte paintType, EnumFacing facing) {
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
        this.dimensionId = dimensionId;
        this.rgb = rgb;
        this.paintType = paintType;
        this.facing = facing;
    }

    public void undo(World world) {
        if (world.field_73011_w.getDimension() != this.dimensionId) {
            return;
        }
        IBlockState state = world.func_180495_p(new BlockPos(this.blockX, this.blockY, this.blockZ));
        Block block = state.func_177230_c();
        if (block instanceof IPantableBlock) {
            Color c = new Color(this.rgb[0] & 0xFF, this.rgb[1] & 0xFF, this.rgb[2] & 0xFF);
            int rgb = c.getRGB();
            IPantableBlock worldColourable = (IPantableBlock)block;
            BlockPos pos = new BlockPos(this.blockX, this.blockY, this.blockZ);
            worldColourable.setColour((IBlockAccess)world, pos, rgb, this.facing);
            worldColourable.setPaintType((IBlockAccess)world, pos, PaintTypeRegistry.getInstance().getPaintTypeFormByte(this.paintType), this.facing);
        }
    }
}

