/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass;

import com.chaosthedude.explorerscompass.client.ClientEventHandler;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.network.CompassSearchPacket;
import com.chaosthedude.explorerscompass.network.SyncPacket;
import com.chaosthedude.explorerscompass.network.TeleportPacket;
import com.chaosthedude.explorerscompass.util.CompassState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="explorerscompass")
public class ExplorersCompass {
    public static final String MODID = "explorerscompass";
    public static final Logger LOGGER = LogManager.getLogger((String)"explorerscompass");
    public static SimpleChannel network;
    public static ExplorersCompassItem explorersCompass;
    public static boolean canTeleport;
    public static List<Structure<?>> allowedStructures;
    public static Map<Structure<?>, List<ResourceLocation>> dimensionsForAllowedStructures;

    public ExplorersCompass() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHandler.GENERAL_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHandler.CLIENT_SPEC);
    }

    private void preInit(FMLCommonSetupEvent event) {
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> "1.0", s -> true, s -> true);
        network.registerMessage(0, CompassSearchPacket.class, CompassSearchPacket::toBytes, CompassSearchPacket::new, CompassSearchPacket::handle);
        network.registerMessage(1, TeleportPacket.class, TeleportPacket::toBytes, TeleportPacket::new, TeleportPacket::handle);
        network.registerMessage(2, SyncPacket.class, SyncPacket::toBytes, SyncPacket::new, SyncPacket::handle);
        allowedStructures = new ArrayList();
        dimensionsForAllowedStructures = new HashMap();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        ItemModelsProperties.func_239418_a_((Item)explorersCompass, (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, ClientWorld world, LivingEntity entityLiving) {
                LivingEntity entity;
                if (entityLiving == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean entityExists = entityLiving != null;
                Object object = entity = entityExists ? entityLiving : stack.func_82836_z();
                if (world == null && entity.field_70170_p instanceof ClientWorld) {
                    world = (ClientWorld)entity.field_70170_p;
                }
                double rotation = entityExists ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                double adjusted = Math.PI - (((rotation %= 360.0) - 90.0) * 0.01745329238474369 - this.getAngle(world, (Entity)entity, stack));
                if (entityExists) {
                    adjusted = this.wobble(world, adjusted);
                }
                float f = (float)(adjusted / (Math.PI * 2));
                return MathHelper.func_188207_b((float)f, (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(ClientWorld world, double amount) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.func_82737_E();
                    double d0 = amount - this.rotation;
                    d0 %= Math.PI * 2;
                    d0 = MathHelper.func_151237_a((double)d0, (double)-1.0, (double)1.0);
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation += this.rota;
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity itemFrame) {
                return MathHelper.func_188209_b((int)(180 + itemFrame.func_174811_aO().func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getAngle(ClientWorld world, Entity entity, ItemStack stack) {
                if (stack.func_77973_b() == explorersCompass) {
                    ExplorersCompassItem compassItem = (ExplorersCompassItem)stack.func_77973_b();
                    BlockPos pos = compassItem.getState(stack) == CompassState.FOUND ? new BlockPos(compassItem.getFoundStructureX(stack), 0, compassItem.getFoundStructureZ(stack)) : world.func_239140_u_();
                    return Math.atan2((double)pos.func_177952_p() - entity.func_213303_ch().field_72449_c, (double)pos.func_177958_n() - entity.func_213303_ch().field_72450_a);
                }
                return 0.0;
            }
        });
    }
}

