/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import noppes.vc.VCEntities;
import noppes.vc.VCWeapons;
import noppes.vc.client.VCSounds;

public class EntityHolyHandGrenade
extends ThrowableEntity {
    private static final DataParameter<Boolean> Gravity = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Arrow = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Is3d = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Glows = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Rotating = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Sticks = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> Velocity = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> Particle = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (IDataSerializer)DataSerializers.field_187192_b);
    private BlockState inBlock;
    public boolean inGround = false;
    public boolean canBePickedUp = false;
    public boolean destroyedOnEntityHit = true;
    private Entity thrower;
    private String throwerName = null;
    private int ticksInGround;
    public int ticksInAir = 0;
    private double accelerationX;
    private double accelerationY;
    private double accelerationZ;
    public float damage = 5.0f;
    public int punch = 0;
    public boolean accelerate = false;
    public boolean explosiveDamage = true;
    public int explosiveRadius = 0;
    public int duration = 5;
    public int timeToLive = 1200;

    public EntityHolyHandGrenade(EntityType type, World par1World) {
        super(type, par1World);
    }

    public EntityHolyHandGrenade(World par1World) {
        this(VCEntities.holyHandGrenade, par1World);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(Velocity, (Object)10);
        this.field_70180_af.func_187214_a(Particle, (Object)0);
        this.field_70180_af.func_187214_a(Gravity, (Object)false);
        this.field_70180_af.func_187214_a(Glows, (Object)false);
        this.field_70180_af.func_187214_a(Arrow, (Object)false);
        this.field_70180_af.func_187214_a(Is3d, (Object)false);
        this.field_70180_af.func_187214_a(Rotating, (Object)false);
        this.field_70180_af.func_187214_a(Sticks, (Object)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double par1) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public EntityHolyHandGrenade(World par1World, LivingEntity par2EntityLiving, ItemStack item) {
        this(par1World);
        this.thrower = par2EntityLiving;
        if (this.thrower != null) {
            this.throwerName = this.thrower.func_110124_au().toString();
        }
        this.field_70180_af.func_187227_b(Arrow, (Object)(this.getItem() == Items.field_151032_g ? 1 : 0));
        this.func_70012_b(par2EntityLiving.func_226277_ct_(), par2EntityLiving.func_226278_cu_() + (double)par2EntityLiving.func_70047_e(), par2EntityLiving.func_226281_cx_(), par2EntityLiving.field_70177_z, par2EntityLiving.field_70125_A);
        double posX = this.func_226277_ct_() - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.1f);
        double posY = this.func_226278_cu_() - (double)0.1f;
        double posZ = this.func_226281_cx_() - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.1f);
        this.func_70107_b(posX, posY, posZ);
    }

    public void func_70186_c(double par1, double par3, double par5, float par7, float par8) {
        float f2 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        float f3 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        float yaw = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        float pitch = this.hasGravity() ? par7 : (float)(Math.atan2(par3, f3) * 180.0 / Math.PI);
        this.field_70126_B = this.field_70177_z = yaw;
        this.field_70127_C = this.field_70125_A = pitch;
        Vector3d m = new Vector3d((double)(MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))), (double)MathHelper.func_76126_a((float)((pitch + 1.0f) / 180.0f * (float)Math.PI)), (double)(MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)))).func_72441_c(this.field_70146_Z.nextGaussian() * 0.0075 * (double)par8, this.field_70146_Z.nextGaussian() * 0.0075 * (double)par8, this.field_70146_Z.nextGaussian() * 0.0075 * (double)par8).func_186678_a((double)this.getSpeed());
        this.func_213317_d(m);
        this.accelerationX = par1 / (double)f2 * 0.1;
        this.accelerationY = par3 / (double)f2 * 0.1;
        this.accelerationZ = par5 / (double)f2 * 0.1;
        this.ticksInGround = 0;
    }

    public float getAngleForXYZ(double varX, double varY, double varZ, double horiDist, boolean arc) {
        float g = this.func_70185_h();
        float var1 = this.getSpeed() * this.getSpeed();
        double var2 = (double)g * horiDist;
        double var3 = (double)g * horiDist * horiDist + 2.0 * varY * (double)var1;
        double var4 = (double)(var1 * var1) - (double)g * var3;
        if (var4 < 0.0) {
            return 30.0f;
        }
        float var6 = arc ? var1 + MathHelper.func_76133_a((double)var4) : var1 - MathHelper.func_76133_a((double)var4);
        float var7 = (float)(Math.atan2(var6, var2) * 180.0 / Math.PI);
        return var7;
    }

    public void shoot(float speed) {
        double varX = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double varZ = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double varY = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(varX, varY, varZ, -this.field_70125_A, speed);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double par1, double par3, double par5, float par7, float par8, int par9, boolean bo) {
        if (this.field_70170_p.field_72995_K && this.inGround) {
            return;
        }
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    public void func_70071_h_() {
        VoxelShape shape;
        super.func_70030_z();
        Vector3d motion = this.func_213322_ci();
        BlockPos blockpos = this.func_233580_cy_();
        BlockState state = null;
        try {
            state = this.field_70170_p.func_180495_p(blockpos);
        }
        catch (Exception e) {
            return;
        }
        if ((this.isArrow() || this.sticksToWalls()) && !state.isAir((IBlockReader)this.field_70170_p, blockpos) && !(shape = state.func_196954_c((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : shape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.inGround) {
            if (state == this.inBlock) {
                ++this.ticksInGround;
                if (this.ticksInGround > this.timeToLive) {
                    boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
                    this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 10.0f, flag ? Explosion.Mode.BREAK : Explosion.Mode.NONE);
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            ++this.ticksInAir;
            if (this.ticksInAir > 1200) {
                this.func_70106_y();
            }
            Vector3d pos = this.func_213303_ch();
            Vector3d nextpos = pos.func_178787_e(motion);
            RayTraceResult movingobjectposition = ProjectileHelper.func_234618_a_((Entity)this, this::canHit);
            if (movingobjectposition.func_216346_c() != RayTraceResult.Type.MISS) {
                this.field_70180_af.func_187227_b(Rotating, (Object)false);
                this.func_70227_a(movingobjectposition);
            }
            float f1 = MathHelper.func_76133_a((double)EntityHolyHandGrenade.func_213296_b((Vector3d)motion));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.2957763671875);
            this.field_70177_z = EntityHolyHandGrenade.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            this.field_70127_C = this.field_70125_A;
            if (this.isRotating()) {
                this.field_70125_A += this.getSpeed() * -60.0f;
            }
            float f2 = this.getMotionFactor();
            float f3 = this.func_70185_h();
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, nextpos.field_72450_a - motion.field_72450_a * 0.25, nextpos.field_72448_b - motion.field_72448_b * 0.25, nextpos.field_72449_c - motion.field_72449_c * 0.25, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
                }
                f2 = 0.6f;
            }
            motion = motion.func_186678_a((double)f2);
            if (this.hasGravity()) {
                motion = motion.func_178786_a(0.0, (double)f3, 0.0);
            }
            if (this.accelerate) {
                motion = motion.func_72441_c(this.accelerationX, this.accelerationY, this.accelerationZ);
            }
            this.func_213317_d(motion);
            this.func_70107_b(nextpos.field_72450_a, nextpos.field_72448_b, nextpos.field_72449_c);
            this.func_145775_I();
        }
    }

    public static void playSound(Entity entity, SoundEvent sound, float volume, float pitch) {
        if (!entity.field_70170_p.field_72995_K && sound != null && sound.getRegistryName() != null) {
            SPlaySoundPacket packet = new SPlaySoundPacket(sound.getRegistryName(), SoundCategory.NEUTRAL, entity.func_213303_ch(), volume, pitch);
            Optional.ofNullable(entity.func_184102_h()).ifPresent(server -> server.func_184103_al().func_148543_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), volume > 1.0f ? (double)(16.0f * volume) : 16.0, entity.field_70170_p.func_234923_W_(), (IPacket)packet));
        }
    }

    public boolean isBlock() {
        ItemStack item = this.getItemDisplay();
        if (item.func_190926_b()) {
            return false;
        }
        return item.func_77973_b() instanceof BlockItem;
    }

    private Item getItem() {
        ItemStack item = this.getItemDisplay();
        if (item.func_190926_b()) {
            return Items.field_190931_a;
        }
        return item.func_77973_b();
    }

    protected float getMotionFactor() {
        return this.accelerate ? 0.95f : 1.0f;
    }

    protected boolean canHit(Entity entity) {
        if (!super.func_230298_a_(entity) || entity == this.thrower || this.thrower != null && this.thrower.func_184191_r(entity)) {
            return false;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity entityplayer = (PlayerEntity)entity;
            if (entityplayer.field_71075_bZ.field_75102_a || this.thrower instanceof PlayerEntity && !((PlayerEntity)this.thrower).func_96122_a(entityplayer)) {
                return false;
            }
        }
        return true;
    }

    protected void func_70227_a(RayTraceResult movingobjectposition) {
        if (movingobjectposition.func_216346_c() == RayTraceResult.Type.ENTITY) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.ticksInAir = 0;
        } else {
            try {
                this.inBlock = this.field_70170_p.func_180495_p(((BlockRayTraceResult)movingobjectposition).func_216350_a());
                this.inBlock.func_196950_a(this.field_70170_p, this.func_233580_cy_(), (Entity)this);
                EntityHolyHandGrenade.playSound((Entity)this, VCSounds.HALLELUJAH, 4.0f, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Vector3d vector3d = movingobjectposition.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.func_213317_d(vector3d);
            Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)0.05f);
            this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
            this.inGround = true;
            if (!this.hasGravity()) {
                this.field_70180_af.func_187227_b(Gravity, (Object)true);
            }
        }
    }

    public void func_213281_b(CompoundNBT par1NBTTagCompound) {
        if (this.inBlock != null) {
            par1NBTTagCompound.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.inBlock));
        }
        par1NBTTagCompound.func_74757_a("inGround", this.inGround);
        par1NBTTagCompound.func_74757_a("isArrow", this.isArrow());
        Vector3d m = this.func_213322_ci();
        par1NBTTagCompound.func_218657_a("direction", (INBT)this.func_70087_a(new double[]{m.field_72450_a, m.field_72448_b, m.field_72449_c}));
        par1NBTTagCompound.func_74757_a("canBePickedUp", this.canBePickedUp);
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof PlayerEntity) {
            this.throwerName = this.thrower.func_110124_au().toString();
        }
        par1NBTTagCompound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
        par1NBTTagCompound.func_218657_a("Item", (INBT)this.getItemDisplay().func_77955_b(new CompoundNBT()));
        par1NBTTagCompound.func_74776_a("damagev2", this.damage);
        par1NBTTagCompound.func_74768_a("punch", this.punch);
        par1NBTTagCompound.func_74768_a("velocity", ((Integer)this.field_70180_af.func_187225_a(Velocity)).intValue());
        par1NBTTagCompound.func_74768_a("explosiveRadius", this.explosiveRadius);
        par1NBTTagCompound.func_74768_a("effectDuration", this.duration);
        par1NBTTagCompound.func_74757_a("gravity", this.hasGravity());
        par1NBTTagCompound.func_74757_a("accelerate", this.accelerate);
        par1NBTTagCompound.func_74757_a("glows", ((Boolean)this.field_70180_af.func_187225_a(Glows)).booleanValue());
        par1NBTTagCompound.func_74768_a("trailenum", ((Integer)this.field_70180_af.func_187225_a(Particle)).intValue());
        par1NBTTagCompound.func_74757_a("Render3D", ((Boolean)this.field_70180_af.func_187225_a(Is3d)).booleanValue());
        par1NBTTagCompound.func_74757_a("Spins", ((Boolean)this.field_70180_af.func_187225_a(Rotating)).booleanValue());
        par1NBTTagCompound.func_74757_a("Sticks", ((Boolean)this.field_70180_af.func_187225_a(Sticks)).booleanValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        CompoundNBT var2;
        ItemStack item;
        if (compound.func_150297_b("inBlockState", 10)) {
            this.inBlock = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("inBlockState"));
        }
        this.inGround = compound.func_74771_c("inGround") == 1;
        this.field_70180_af.func_187227_b(Arrow, (Object)compound.func_74767_n("isArrow"));
        this.throwerName = compound.func_74779_i("ownerName");
        this.canBePickedUp = compound.func_74767_n("canBePickedUp");
        this.damage = compound.func_74760_g("damagev2");
        this.punch = compound.func_74762_e("punch");
        this.explosiveRadius = compound.func_74762_e("explosiveRadius");
        this.duration = compound.func_74762_e("effectDuration");
        this.accelerate = compound.func_74767_n("accelerate");
        this.field_70180_af.func_187227_b(Particle, (Object)compound.func_74762_e("trailenum"));
        this.field_70180_af.func_187227_b(Glows, (Object)compound.func_74767_n("glows"));
        this.field_70180_af.func_187227_b(Velocity, (Object)compound.func_74762_e("velocity"));
        this.field_70180_af.func_187227_b(Gravity, (Object)compound.func_74767_n("gravity"));
        this.field_70180_af.func_187227_b(Is3d, (Object)compound.func_74767_n("Render3D"));
        this.field_70180_af.func_187227_b(Rotating, (Object)compound.func_74767_n("Spins"));
        this.field_70180_af.func_187227_b(Sticks, (Object)compound.func_74767_n("Sticks"));
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
        if (compound.func_74764_b("direction")) {
            ListNBT nbttaglist = compound.func_150295_c("direction", 6);
            this.func_213317_d(new Vector3d(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2)));
        }
        if ((item = ItemStack.func_199557_a((CompoundNBT)(var2 = compound.func_74775_l("Item")))).func_190926_b()) {
            this.func_70106_y();
        }
    }

    public Entity func_234616_v_() {
        if (this.throwerName == null || this.throwerName.isEmpty()) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(this.throwerName);
            if (this.thrower == null && uuid != null) {
                this.thrower = this.field_70170_p.func_217371_b(uuid);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.thrower;
    }

    public void setParticleEffect(int type) {
        this.field_70180_af.func_187227_b(Particle, (Object)type);
    }

    public void setHasGravity(boolean bo) {
        this.field_70180_af.func_187227_b(Gravity, (Object)bo);
    }

    public void setIs3D(boolean bo) {
        this.field_70180_af.func_187227_b(Is3d, (Object)bo);
    }

    public void setStickInWall(boolean bo) {
        this.field_70180_af.func_187227_b(Sticks, (Object)bo);
    }

    public ItemStack getItemDisplay() {
        return new ItemStack((IItemProvider)VCWeapons.holy_hand_grenade);
    }

    public float func_70013_c() {
        return (Boolean)this.field_70180_af.func_187225_a(Glows) != false ? 1.0f : super.func_70013_c();
    }

    public boolean hasGravity() {
        return (Boolean)this.field_70180_af.func_187225_a(Gravity);
    }

    public void setSpeed(int speed) {
        this.field_70180_af.func_187227_b(Velocity, (Object)speed);
    }

    public float getSpeed() {
        return (float)((Integer)this.field_70180_af.func_187225_a(Velocity)).intValue() / 10.0f;
    }

    public boolean isArrow() {
        return (Boolean)this.field_70180_af.func_187225_a(Arrow);
    }

    public void setRotating(boolean bo) {
        this.field_70180_af.func_187227_b(Rotating, (Object)bo);
    }

    public boolean isRotating() {
        return (Boolean)this.field_70180_af.func_187225_a(Rotating);
    }

    public boolean glows() {
        return (Boolean)this.field_70180_af.func_187225_a(Glows);
    }

    public boolean is3D() {
        return (Boolean)this.field_70180_af.func_187225_a(Is3d) != false || this.isBlock();
    }

    public boolean sticksToWalls() {
        return this.is3D() && (Boolean)this.field_70180_af.func_187225_a(Sticks) != false;
    }

    public void func_70100_b_(PlayerEntity par1EntityPlayer) {
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        if (!this.getItemDisplay().func_190926_b()) {
            return this.getItemDisplay().func_151000_E();
        }
        return super.func_145748_c_();
    }

    public IPacket<?> func_213297_N() {
        Entity entity = this.func_234616_v_();
        return new SSpawnObjectPacket((Entity)this, entity == null ? 0 : entity.func_145782_y());
    }

    public static interface IProjectileDeadCallback {
        public boolean onImpact(EntityHolyHandGrenade var1);
    }

    public static interface IProjectileCallback {
        public boolean onImpact(EntityHolyHandGrenade var1, BlockPos var2, Entity var3);
    }
}

