/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.blocks.BlockBasicContainer;
import noppes.vc.blocks.VCBlockStateProperties;

public abstract class BlockBasicLightable
extends BlockBasicContainer {
    public static final BooleanProperty LIT = VCBlockStateProperties.LIT;
    public static final IntegerProperty TYPE = VCBlockStateProperties.TYPE;

    protected BlockBasicLightable(AbstractBlock.Properties properties, boolean lit) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(lit)));
    }

    public abstract Block unlitBlock();

    public abstract Block litBlock();

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        TileEntity tile = level.func_175625_s(pos);
        if (this.litBlock() == this) {
            level.func_180501_a(pos, this.unlitBlock().func_176223_P(), 2);
        } else {
            level.func_180501_a(pos, this.litBlock().func_176223_P(), 2);
        }
        tile.func_145829_t();
        level.func_175690_a(pos, tile);
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (context.func_196000_l() == Direction.UP) {
            return (BlockState)state.func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(0));
        }
        if (context.func_196000_l() == Direction.DOWN) {
            return (BlockState)state.func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(1));
        }
        return (BlockState)state.func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(2));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIT});
        builder.func_206894_a(new Property[]{TYPE});
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader level, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.litBlock());
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)this.litBlock());
    }
}

