/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.VCBlocks;
import noppes.vc.blocks.BlockBasicLightable;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileCandle;

public class BlockCandle
extends BlockBasicLightable {
    public static final VoxelShape AABB_NORMAL = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, 0.5, (double)0.7f));
    public static final VoxelShape AABB_UP = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.1f, (double)0.1f, (double)0.1f, (double)0.9f, (double)0.8f, (double)0.9f));
    public static final VoxelShape AABB0 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.2f, (double)0.4f, (double)0.2f, (double)0.8f, (double)0.9f, (double)0.8f));
    public static final VoxelShape AABB1 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.2f, (double)0.4f, (double)0.4f, (double)0.8f, (double)0.9f, 1.0));
    public static final VoxelShape AABB2 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.2f, (double)0.4f, 0.0, (double)0.8f, (double)0.9f, (double)0.6f));
    public static final VoxelShape AABB3 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.4f, (double)0.4f, (double)0.2f, 1.0, (double)0.9f, (double)0.8f));
    public static final VoxelShape AABB4 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, (double)0.4f, (double)0.2f, (double)0.6f, (double)0.9f, (double)0.8f));
    private static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_0_7;

    public BlockCandle(boolean lit) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150339_S).func_226896_b_(), lit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        int type = (Integer)state.func_177229_b((Property)TYPE);
        if (type == 2) {
            int rotation = (Integer)state.func_177229_b((Property)ROTATION);
            if (rotation == 0) {
                return AABB1;
            }
            if (rotation == 4) {
                return AABB2;
            }
            if (rotation == 6) {
                return AABB3;
            }
            if (rotation == 2) {
                return AABB4;
            }
            return AABB0;
        }
        if (type == 1) {
            return AABB_UP;
        }
        return AABB_NORMAL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ROTATION});
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 45.0f) + 0.5)) & 7;
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileCandle();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World level, BlockPos pos, Random rand) {
        if (this == this.unlitBlock()) {
            return;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int type = (Integer)state.func_177229_b((Property)TYPE);
        int rotation = (Integer)state.func_177229_b((Property)ROTATION);
        if (type == 1) {
            if (rotation % 2 == 0) {
                level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)x + 0.5f), (double)((float)y + 0.66f), (double)((float)z + 0.13f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)x + 0.5f), (double)((float)y + 0.65f), (double)((float)z + 0.13f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)x + 0.5f), (double)((float)y + 0.66f), (double)((float)z + 0.87f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)x + 0.5f), (double)((float)y + 0.65f), (double)((float)z + 0.87f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)x + 0.13f), (double)((float)y + 0.66f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)x + 0.13f), (double)((float)y + 0.65f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)x + 0.87f), (double)((float)y + 0.66f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)x + 0.87f), (double)((float)y + 0.65f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0);
            } else {
                level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)x + 0.24f), (double)((float)y + 0.66f), (double)((float)z + 0.24f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)x + 0.24f), (double)((float)y + 0.65f), (double)((float)z + 0.24f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)x + 0.76f), (double)((float)y + 0.66f), (double)((float)z + 0.76f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)x + 0.76f), (double)((float)y + 0.65f), (double)((float)z + 0.76f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)x + 0.24f), (double)((float)y + 0.66f), (double)((float)z + 0.76f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)x + 0.24f), (double)((float)y + 0.65f), (double)((float)z + 0.76f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)x + 0.76f), (double)((float)y + 0.66f), (double)((float)z + 0.24f), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)x + 0.76f), (double)((float)y + 0.65f), (double)((float)z + 0.24f), 0.0, 0.0, 0.0);
            }
        } else {
            float xOffset = 0.5f;
            float yOffset = 0.45f;
            float zOffset = 0.5f;
            if (type == 2) {
                yOffset = 1.05f;
                if (rotation == 0) {
                    zOffset += 0.12f;
                }
                if (rotation == 4) {
                    zOffset -= 0.12f;
                }
                if (rotation == 6) {
                    xOffset += 0.12f;
                }
                if (rotation == 2) {
                    xOffset -= 0.12f;
                }
            }
            double d0 = (float)x + xOffset;
            double d1 = (float)y + yOffset;
            double d2 = (float)z + zOffset;
            level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
            level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Block unlitBlock() {
        return VCBlocks.candle_unlit;
    }

    @Override
    public Block litBlock() {
        return VCBlocks.candle;
    }
}

