/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.EntitySize;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.EntityProjectile;

@OnlyIn(value=Dist.CLIENT)
public class RenderProjectile<T extends EntityProjectile>
extends EntityRenderer<T> {
    public boolean renderWithColor = true;
    private static final ResourceLocation field_110780_a = new ResourceLocation("textures/entity/arrow.png");
    private static final ResourceLocation field_110798_h = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private boolean crash = false;
    private boolean crash2 = false;

    public RenderProjectile(EntityRendererManager manager) {
        super(manager);
    }

    public void render(T projectile, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        Minecraft mc = Minecraft.func_71410_x();
        matrixStack.func_227860_a_();
        float scale = (float)((EntityProjectile)((Object)projectile)).getSize() / 10.0f;
        ItemStack item = ((EntityProjectile)((Object)projectile)).getItemDisplay();
        matrixStack.func_227862_a_(scale, scale, scale);
        if (((EntityProjectile)((Object)projectile)).isArrow()) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((EntityProjectile)((Object)projectile)).field_70126_B, (float)((EntityProjectile)((Object)projectile)).field_70177_z) - 90.0f));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((EntityProjectile)((Object)projectile)).field_70127_C, (float)((EntityProjectile)((Object)projectile)).field_70125_A)));
            float f9 = (float)((EntityProjectile)((Object)projectile)).arrowShake - partialTicks;
            if (f9 > 0.0f) {
                float f10 = -MathHelper.func_76126_a((float)(f9 * 3.0f)) * f9;
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f10));
            }
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(45.0f));
            matrixStack.func_227862_a_(0.05625f, 0.05625f, 0.05625f);
            matrixStack.func_227861_a_(-4.0, 0.0, 0.0);
            IVertexBuilder ivertexbuilder = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTextureLocation(projectile)));
            MatrixStack.Entry matrixstack$entry = matrixStack.func_227866_c_();
            Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
            Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, packedLight);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, packedLight);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, packedLight);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, packedLight);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, packedLight);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, packedLight);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, packedLight);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, packedLight);
            for (int j = 0; j < 4; ++j) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, packedLight);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, packedLight);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, packedLight);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, packedLight);
            }
        } else if (((EntityProjectile)((Object)projectile)).is3D()) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((EntityProjectile)((Object)projectile)).field_70126_B, (float)((EntityProjectile)((Object)projectile)).field_70177_z) - 180.0f));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((EntityProjectile)((Object)projectile)).field_70127_C, (float)((EntityProjectile)((Object)projectile)).field_70125_A) - 90.0f));
            EntitySize size = ((EntityProjectile)((Object)projectile)).func_213305_a(null);
            matrixStack.func_227861_a_(0.0, 0.0, (double)(size.field_220316_b / 2.0f));
            if (item.func_77973_b() instanceof BlockItem && Block.func_149634_a((Item)item.func_77973_b()).func_176223_P().func_185901_i() == BlockRenderType.ENTITYBLOCK_ANIMATED) {
                matrixStack.func_227861_a_(0.0, 0.1875, -0.3125);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(20.0f));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
                float f8 = 0.375f;
                matrixStack.func_227862_a_(-f8, -f8, f8);
            }
            if (!this.crash) {
                try {
                    mc.func_175599_af().func_229110_a_(item, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
                }
                catch (Throwable e) {
                    this.crash = true;
                }
            } else if (!this.crash2) {
                try {
                    mc.func_175599_af().func_229110_a_(item, ItemCameraTransforms.TransformType.NONE, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
                }
                catch (Throwable ee) {
                    this.crash2 = true;
                }
            } else {
                mc.func_175599_af().func_229110_a_(new ItemStack((IItemProvider)Blocks.field_150346_d), ItemCameraTransforms.TransformType.GROUND, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
            }
        } else {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227863_a_(this.field_76990_c.field_217783_c.func_227995_f_());
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            mc.func_175599_af().func_229110_a_(item, ItemCameraTransforms.TransformType.GROUND, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
        }
        if (!((EntityProjectile)((Object)projectile)).is3D() || ((EntityProjectile)((Object)projectile)).glows()) {
            // empty if block
        }
        matrixStack.func_227865_b_();
    }

    protected ResourceLocation func_110779_a(EntityProjectile projectile) {
        return projectile.isArrow() ? field_110780_a : AtlasTexture.field_110575_b;
    }

    public ResourceLocation getTextureLocation(T par1Entity) {
        return ((EntityProjectile)((Object)par1Entity)).isArrow() ? field_110780_a : AtlasTexture.field_110575_b;
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, IVertexBuilder vertexBuilder, int offsetX, int offsetY, int offsetZ, float textureX, float textureY, int p_229039_9_, int p_229039_10_, int p_229039_11_, int packedLightIn) {
        vertexBuilder.func_227888_a_(matrix, (float)offsetX, (float)offsetY, (float)offsetZ).func_225586_a_(255, 255, 255, 255).func_225583_a_(textureX, textureY).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(normals, (float)p_229039_9_, (float)p_229039_11_, (float)p_229039_10_).func_181675_d();
    }
}

