/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import noppes.vc.EntityProjectile;
import noppes.vc.VCEntities;
import noppes.vc.VCTabs;
import noppes.vc.VCWeapons;
import noppes.vc.client.VCSounds;
import noppes.vc.items.ItemBasic;

public class ItemMachineGun
extends ItemBasic {
    public ItemMachineGun() {
        super(new Item.Properties().func_200915_b(80).func_200916_a(VCTabs.WEAPONS));
    }

    public void func_77615_a(ItemStack stack, World par2level, LivingEntity entity, int count) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        CompoundNBT compound = stack.func_196082_o();
        int ticks = this.func_77626_a(stack) - count;
        int shotsleft = compound.func_74762_e("ShotsLeft") - ticks / 6;
        if (compound.func_74767_n("Reloading2")) {
            shotsleft = ticks / 5;
            if (ticks > 40) {
                shotsleft = 8;
            }
            if (shotsleft > 1) {
                compound.func_74768_a("ShotsLeft", shotsleft);
                compound.func_74757_a("Reloading2", false);
            }
        } else if (shotsleft <= 0) {
            compound.func_74757_a("Reloading2", true);
            stack.func_190918_g(1);
        } else {
            compound.func_74768_a("ShotsLeft", shotsleft);
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int ticks = this.func_77626_a(stack) - count;
        if (ticks % 6 != 0) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            CompoundNBT compound = stack.func_196082_o();
            int shotsleft = compound.func_74762_e("ShotsLeft") - ticks / 6;
            if (!player.field_71075_bZ.field_75098_d) {
                if (compound.func_74767_n("Reloading2") && this.hasItem(player, VCWeapons.bullet)) {
                    if (ticks > 0 && ticks <= 24) {
                        ItemMachineGun.playSound((LivingEntity)player, VCSounds.GUN_AK47_LOAD, 1.0f, 1.0f);
                    }
                    return;
                }
                if (shotsleft <= 0 || !this.hasItem(player, VCWeapons.bullet)) {
                    ItemMachineGun.playSound((LivingEntity)player, VCSounds.GUN_EMPTY, 1.0f, 1.0f);
                    return;
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.consumeItem(player, VCWeapons.bullet);
            }
            compound.func_82580_o("Reloading2");
        }
        EntityProjectile projectile = new EntityProjectile(VCEntities.Projectile, entity.field_70170_p, entity, new ItemStack((IItemProvider)VCWeapons.bullet, 0));
        projectile.damage = 4.0f;
        projectile.setSpeed(40);
        projectile.shoot(2.0f);
        ItemMachineGun.playSound(entity, VCSounds.GUN_PISTAL_SHOT, 0.9f, field_77697_d.nextFloat() * 0.3f + 0.8f);
        entity.field_70170_p.func_217376_c((Entity)projectile);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (!player.field_71075_bZ.field_75098_d && !this.hasItem(player, VCWeapons.bullet)) {
            itemstack.func_77983_a("Reloading2", (INBT)ByteNBT.func_229671_a_((byte)1));
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("Reloading2")) {
            return UseAction.BOW;
        }
        return UseAction.BLOCK;
    }
}

