/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.shared.client.gui.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3f;
import noppes.vc.shared.client.gui.components.GuiBasic;
import noppes.vc.shared.client.gui.components.GuiBasicContainer;
import noppes.vc.shared.client.gui.components.GuiButtonNop;
import noppes.vc.shared.client.gui.components.GuiCustomScroll;
import noppes.vc.shared.client.gui.components.GuiHoverText;
import noppes.vc.shared.client.gui.components.GuiLabel;
import noppes.vc.shared.client.gui.components.GuiMenuSideButton;
import noppes.vc.shared.client.gui.components.GuiMenuTopButton;
import noppes.vc.shared.client.gui.components.GuiSliderNop;
import noppes.vc.shared.client.gui.components.GuiTextFieldNop;
import noppes.vc.shared.client.gui.listeners.IGui;
import noppes.vc.shared.client.gui.listeners.IGuiInterface;
import noppes.vc.shared.client.gui.listeners.IKeyListener;
import noppes.vc.shared.client.gui.listeners.IMouseListener;

public class GuiWrapper {
    public Map<Integer, GuiButtonNop> npcbuttons = new ConcurrentHashMap<Integer, GuiButtonNop>();
    public Map<Integer, GuiMenuTopButton> topbuttons = new ConcurrentHashMap<Integer, GuiMenuTopButton>();
    public Map<Integer, GuiMenuSideButton> sidebuttons = new ConcurrentHashMap<Integer, GuiMenuSideButton>();
    public Map<Integer, GuiTextFieldNop> textfields = new ConcurrentHashMap<Integer, GuiTextFieldNop>();
    public Map<Integer, GuiLabel> labels = new ConcurrentHashMap<Integer, GuiLabel>();
    public Map<Integer, GuiCustomScroll> scrolls = new ConcurrentHashMap<Integer, GuiCustomScroll>();
    public Map<Integer, GuiSliderNop> sliders = new ConcurrentHashMap<Integer, GuiSliderNop>();
    public Map<Integer, Screen> extra = new ConcurrentHashMap<Integer, Screen>();
    public List<IGui> components = new ArrayList<IGui>();
    public Screen parent;
    public Screen gui;
    public Screen subgui;
    public int mouseX;
    public int mouseY;

    public GuiWrapper(Screen gui) {
        this.gui = gui;
    }

    public void init(Minecraft mc, int width, int height) {
        GuiTextFieldNop.unfocus();
        if (this.subgui != null) {
            this.subgui.func_231158_b_(mc, width, height);
        }
        this.npcbuttons = new ConcurrentHashMap<Integer, GuiButtonNop>();
        this.topbuttons = new ConcurrentHashMap<Integer, GuiMenuTopButton>();
        this.sidebuttons = new ConcurrentHashMap<Integer, GuiMenuSideButton>();
        this.textfields = new ConcurrentHashMap<Integer, GuiTextFieldNop>();
        this.labels = new ConcurrentHashMap<Integer, GuiLabel>();
        this.scrolls = new ConcurrentHashMap<Integer, GuiCustomScroll>();
        this.sliders = new ConcurrentHashMap<Integer, GuiSliderNop>();
        this.extra = new ConcurrentHashMap<Integer, Screen>();
        this.components = new ArrayList<IGui>();
    }

    public void tick() {
        if (this.subgui != null) {
            this.subgui.func_231023_e_();
        } else {
            for (GuiTextFieldNop tf : new ArrayList<GuiTextFieldNop>(this.textfields.values())) {
                if (!tf.enabled) continue;
                tf.func_146178_a();
            }
            for (IGui comp : new ArrayList<IGui>(this.components)) {
                comp.tick();
            }
        }
    }

    public void addExtra(GuiHoverText gui) {
        gui.func_231158_b_(Minecraft.func_71410_x(), 350, 250);
        this.extra.put(gui.id, gui);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrolled) {
        if (this.subgui != null) {
            this.subgui.func_231043_a_(mouseX, mouseY, scrolled);
            return true;
        }
        for (IGui comp : new ArrayList<IGui>(this.components)) {
            if (!(comp instanceof IMouseListener) || !comp.isActive() || !((IMouseListener)((Object)comp)).mouseScrolled(scrolled)) continue;
            return true;
        }
        for (GuiCustomScroll scroll : this.scrolls.values()) {
            if (!scroll.visible || !scroll.func_231043_a_(mouseX, mouseY, scrolled)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double i, double j, int k) {
        if (this.subgui != null) {
            this.subgui.func_231044_a_(i, j, k);
            return true;
        }
        for (GuiTextFieldNop tf : new ArrayList<GuiTextFieldNop>(this.textfields.values())) {
            if (!tf.enabled || !tf.func_231044_a_(i, j, k)) continue;
            return true;
        }
        for (IGui comp : new ArrayList<IGui>(this.components)) {
            if (!(comp instanceof IMouseListener) || !((IMouseListener)((Object)comp)).mouseClicked(i, j, k)) continue;
            return true;
        }
        if (k == 0) {
            for (GuiCustomScroll scroll : new ArrayList<GuiCustomScroll>(this.scrolls.values())) {
                if (!scroll.func_231044_a_(i, j, k)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        if (this.subgui != null) {
            this.subgui.func_231045_a_(x, y, button, dx, dy);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.subgui != null) {
            this.subgui.func_231048_c_(x, y, button);
            return true;
        }
        return false;
    }

    public boolean charTyped(char c, int i) {
        if (this.subgui != null) {
            this.subgui.func_231042_a_(c, i);
            return true;
        }
        for (GuiTextFieldNop tf : new ArrayList<GuiTextFieldNop>(this.textfields.values())) {
            tf.func_231042_a_(c, i);
        }
        for (GuiCustomScroll scroll : new ArrayList<GuiCustomScroll>(this.scrolls.values())) {
            scroll.func_231042_a_(c, i);
        }
        for (IGui comp : new ArrayList<IGui>(this.components)) {
            if (!(comp instanceof IKeyListener)) continue;
            ((IKeyListener)((Object)comp)).charTyped(c, i);
        }
        return true;
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.subgui != null) {
            this.subgui.func_231046_a_(key, p_keyPressed_2_, p_keyPressed_3_);
            return true;
        }
        boolean active = GuiTextFieldNop.isActive();
        for (IGui gui : this.components) {
            if (!gui.isActive()) continue;
            active = true;
            break;
        }
        if (this.gui.func_231178_ax__() && (key == 256 || !active && Minecraft.func_71410_x().field_71474_y.field_151445_Q.getKey().func_197937_c() == key)) {
            this.gui.func_231175_as__();
            return true;
        }
        for (GuiTextFieldNop tf : this.textfields.values()) {
            tf.func_231046_a_(key, p_keyPressed_2_, p_keyPressed_3_);
        }
        for (GuiCustomScroll scroll : new ArrayList<GuiCustomScroll>(this.scrolls.values())) {
            scroll.func_231046_a_(key, p_keyPressed_2_, p_keyPressed_3_);
        }
        for (IGui comp : new ArrayList<IGui>(this.components)) {
            if (!(comp instanceof IKeyListener) || !((IKeyListener)((Object)comp)).keyPressed(key, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        return active;
    }

    public void drawNpc(LivingEntity entity, int x, int y, float zoomed, int rotation, int guiLeft, int guiTop) {
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        float scale = 1.0f;
        if ((double)entity.func_213302_cg() > 2.4) {
            scale = 2.0f / entity.func_213302_cg();
        }
        float f7 = (float)(guiLeft + x) - (float)this.mouseX;
        float f8 = (float)(guiTop + y) - 50.0f * scale * zoomed - (float)this.mouseY;
        entity.field_70761_aq = 0.0f;
        entity.field_70177_z = (float)Math.atan(f7 / 80.0f) * 40.0f + (float)rotation;
        entity.field_70125_A = -((float)Math.atan(f8 / 40.0f)) * 20.0f;
        entity.field_70759_as = 0.0f;
        entity.field_70758_at = 0.0f;
        boolean orientation = false;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)guiLeft + (float)x), (float)(guiTop + y), (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_(30.0f * scale * zoomed, 30.0f * scale * zoomed, 30.0f * scale * zoomed);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        EntityRendererManager lvt_16_1_ = Minecraft.func_71410_x().func_175598_ae();
        lvt_16_1_.func_178633_a(false);
        IRenderTypeBuffer.Impl lvt_17_1_ = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)rotation));
        RenderSystem.runAsFancy(() -> lvt_16_1_.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)lvt_17_1_, 0xF000F0));
        lvt_17_1_.func_228461_a_();
        lvt_16_1_.func_178633_a(true);
        RenderSystem.popMatrix();
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
    }

    public void changeFocus(IGuiEventListener old, IGuiEventListener gui) {
        if (old instanceof GuiSliderNop && gui != old) {
            ((GuiSliderNop)old).func_231000_a__(0.0, 0.0);
        }
    }

    public void setSubgui(Screen subgui) {
        this.gui.func_231035_a_(null);
        this.subgui = subgui;
        subgui.func_231158_b_(Minecraft.func_71410_x(), this.gui.field_230708_k_, this.gui.field_230709_l_);
        if (subgui instanceof GuiBasic) {
            ((GuiBasic)subgui).wrapper.parent = this.gui;
        }
        if (subgui instanceof GuiBasicContainer) {
            ((GuiBasicContainer)subgui).wrapper.parent = this.gui;
        }
    }

    public Screen getSubGui() {
        if (this.subgui instanceof IGuiInterface && ((IGuiInterface)this.subgui).hasSubGui()) {
            return ((IGuiInterface)this.subgui).getSubGui();
        }
        return this.subgui;
    }

    public Screen getParent() {
        if (this.parent != null) {
            return ((IGuiInterface)this.parent).getParent();
        }
        return null;
    }

    public void close() {
        ((IGuiInterface)this.gui).save();
        if (this.subgui != null) {
            GuiTextFieldNop.unfocus();
            if (this.parent instanceof IGuiInterface) {
                ((GuiBasic)this.parent).subGuiClosed(this.subgui);
            } else {
                this.gui.func_231175_as__();
            }
        } else {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_195559_v.func_197967_a(false);
            GuiTextFieldNop.unfocus();
            minecraft.func_147108_a(this.gui);
            minecraft.field_71417_B.func_198034_i();
        }
    }
}

