/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.coregraphics;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGBlendMode;
import com.apple.library.coregraphics.CGGradient;
import com.apple.library.coregraphics.CGGraphicsRenderer;
import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.GraphicsContextImpl;
import com.apple.library.impl.ObjectUtilsImpl;
import com.apple.library.impl.TooltipRenderer;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CGGraphicsContext
implements GraphicsContextImpl {
    private final CGGraphicsState state;
    private final CGGraphicsRenderer renderer;

    public CGGraphicsContext(CGGraphicsState state, CGGraphicsRenderer renderer) {
        this.state = state;
        this.renderer = renderer;
    }

    public void drawImage(UIImage image, CGRect rect) {
        UIImage.ClipData clipData;
        UIImage.AnimationData animation;
        CGSize limitSize;
        CGSize size;
        if (image == null) {
            return;
        }
        float u = 0.0f;
        float v = 0.0f;
        float w = rect.width;
        float h = rect.height;
        float mw = 256.0f;
        float mh = 256.0f;
        CGPoint texturePos = image.uv();
        if (texturePos != null) {
            u = texturePos.x;
            v = texturePos.y;
        }
        if ((size = image.size()) != null) {
            w = size.width;
            h = size.height;
        }
        if ((limitSize = image.limit()) != null) {
            mw = limitSize.width;
            mh = limitSize.height;
        }
        if ((animation = image.animationData()) != null && animation.frames != 0) {
            int frame = (int)(System.currentTimeMillis() / (long)animation.speed % (long)animation.frames);
            v += h * (float)frame;
        }
        if ((clipData = image.clipData()) != null) {
            float t = clipData.contentInsets.top;
            float b = clipData.contentInsets.bottom;
            float l = clipData.contentInsets.left;
            float r = clipData.contentInsets.right;
            this.drawTilableImage(image.rl(), rect.x, rect.y, rect.width, rect.height, u, v, w, h, mw, mh, t, b, l, r, 0.0f);
            return;
        }
        CGSize sourceSize = image.source();
        if (sourceSize != null) {
            float sw = sourceSize.width;
            float sh = sourceSize.height;
            this.drawResizableImage(image.rl(), rect.x, rect.y, w, h, u, v, sw, sh, mw, mh);
            return;
        }
        this.drawResizableImage(image.rl(), rect.x, rect.y, w, h, u, v, w, h, mw, mh);
    }

    public void drawText(NSString text, float x, float y, @Nullable UIFont font, @Nullable UIColor color, @Nullable UIColor shadowColor) {
        if (text == null) {
            return;
        }
        if (color == null) {
            color = AppearanceImpl.TEXT_COLOR;
        }
        if (shadowColor != null) {
            this.drawText(text, x, y, color.getRGB(), true, font, 0.0f);
        } else {
            this.drawText(text, x, y, color.getRGB(), false, font, 0.0f);
        }
    }

    public void drawTooltip(Object tooltip, CGRect rect) {
        if (tooltip == null) {
            return;
        }
        NSString text = ObjectUtilsImpl.safeCast(tooltip, NSString.class);
        if (text != null) {
            this.renderer.renderTooltip(text, rect, null, this);
            return;
        }
        TooltipRenderer view = ObjectUtilsImpl.safeCast(tooltip, TooltipRenderer.class);
        if (view != null) {
            view.render(rect, this);
            return;
        }
    }

    public void drawContents(Object contents, CGRect rect, UIView view) {
        if (contents == null) {
            return;
        }
        if (contents instanceof UIImage) {
            this.drawImage((UIImage)contents, rect);
            return;
        }
        if (contents instanceof UIColor) {
            this.fillRect((UIColor)contents, rect);
            return;
        }
        if (contents instanceof CGGradient) {
            this.fillRect((CGGradient)contents, rect);
            return;
        }
    }

    public void drawEntity(LivingEntity entity, int x, int y, int scale, float mouseX, float mouseY) {
        this.renderer.renderEntity(entity, x, y, scale, mouseX, mouseY, this);
    }

    public void drawItem(ItemStack itemStack, int x, int y) {
        this.renderer.renderItem(itemStack, x, y, this);
    }

    public void fillRect(UIColor color, CGRect rect) {
        if (color == null || color == UIColor.CLEAR) {
            return;
        }
        int color1 = color.getRGB();
        this.drawColor(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, 0.0f, color1, color1);
    }

    public void fillRect(float x1, float y1, float x2, float y2, int color) {
        this.drawColor(x1, y1, x2, y2, 0.0f, color, color);
    }

    public void fillRect(CGGradient gradient, CGRect rect) {
        int color1 = gradient.startColor.getRGB();
        int color2 = gradient.endColor.getRGB();
        this.drawColor(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY(), 0.0f, color1, color2);
    }

    public void strokeRect(UIColor color, CGRect rect) {
        RenderSystem.drawBoundingBox(this.state.ctm(), rect, color);
    }

    public void addClipRect(CGRect rect) {
        RenderSystem.addClipRect(rect);
    }

    public void removeClipRect() {
        RenderSystem.removeClipRect();
    }

    public void saveGraphicsState() {
        this.state.save();
    }

    public void translateCTM(float x, float y, float z) {
        this.state.translate(x, y, z);
    }

    public void rotateCTM(float x, float y, float z) {
        this.state.rotate(x, y, z);
    }

    public void concatenateCTM(CGAffineTransform transform) {
        this.state.concatenate(transform);
    }

    public void restoreGraphicsState() {
        this.state.restore();
    }

    public void setBlendMode(CGBlendMode mode) {
    }

    public void enableBlend() {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void disableBlend() {
    }

    public void setBlendColor(UIColor color) {
        RenderSystem.setShaderColor(color);
    }

    public void strokeDebugRect(int tag, CGRect rect) {
        if (ModDebugger.viewHierarchy) {
            this.strokeRect(ColorUtils.getPaletteColor(tag), rect);
        }
    }

    @Override
    public CGGraphicsState state() {
        return this.state;
    }
}

