/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIEdgeInsets;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class LayoutManagerImpl {
    private final ArrayList<Pair<CGRect, UIEdgeInsets>> rects = new ArrayList();
    private final ArrayList<CGRect> results = new ArrayList();

    public <T> void add(T target, UIEdgeInsets edg, Function<T, CGRect> transform) {
        if (target != null) {
            this.add(transform.apply(target), edg);
        } else {
            this.add(null, edg);
        }
    }

    public void add(@Nullable CGRect rect, UIEdgeInsets edg) {
        if (rect == null) {
            this.rects.add(null);
        } else {
            this.rects.add((Pair<CGRect, UIEdgeInsets>)Pair.of((Object)rect, (Object)edg));
        }
    }

    public void applyHorizontalLayout(CGRect bounds, NSTextAlignment.Horizontal horizontalAlignment, NSTextAlignment.Vertical verticalAlignment) {
        this.results.clear();
        int contentWidth = 0;
        for (Pair<CGRect, UIEdgeInsets> pair : this.rects) {
            if (pair == null) continue;
            CGRect rect = (CGRect)pair.getKey();
            UIEdgeInsets edg = (UIEdgeInsets)pair.getValue();
            contentWidth = (int)((float)contentWidth + (edg.left + rect.width + edg.right));
        }
        float dx = bounds.x + this.sel(bounds.width, (float)contentWidth, horizontalAlignment);
        for (Pair<CGRect, UIEdgeInsets> pair : this.rects) {
            if (pair != null) {
                CGRect rect = (CGRect)pair.getKey();
                UIEdgeInsets edg = (UIEdgeInsets)pair.getValue();
                float dy = bounds.y + this.sel(bounds.height - edg.top - edg.bottom, rect.height, verticalAlignment);
                this.results.add(new CGRect(dx + edg.left + rect.x, dy + edg.top + rect.y, rect.width, rect.height));
                dx += rect.width + edg.left + edg.right;
                continue;
            }
            this.results.add(null);
        }
    }

    public void applyVerticalLayout(CGRect bounds, NSTextAlignment.Horizontal horizontalAlignment, NSTextAlignment.Vertical verticalAlignment) {
        this.results.clear();
        int contentHeight = 0;
        for (Pair<CGRect, UIEdgeInsets> pair : this.rects) {
            if (pair == null) continue;
            CGRect rect = (CGRect)pair.getKey();
            UIEdgeInsets edg = (UIEdgeInsets)pair.getValue();
            contentHeight = (int)((float)contentHeight + (edg.top + rect.height + edg.bottom));
        }
        float dy = bounds.y + this.sel(bounds.height, (float)contentHeight, verticalAlignment);
        for (Pair<CGRect, UIEdgeInsets> pair : this.rects) {
            if (pair != null) {
                CGRect rect = (CGRect)pair.getKey();
                UIEdgeInsets edg = (UIEdgeInsets)pair.getValue();
                float dx = bounds.x + this.sel(bounds.width - edg.left - edg.right, rect.width, horizontalAlignment);
                this.results.add(new CGRect(dx + edg.left + rect.x, dy + edg.top + rect.y, rect.width, rect.height));
                dy += rect.height + edg.top + edg.bottom;
                continue;
            }
            this.results.add(null);
        }
    }

    @Nullable
    public CGRect getOrDefault(int index, CGRect defaultValue) {
        CGRect rect;
        if (index >= 0 && index < this.results.size() && (rect = this.results.get(index)) != null) {
            return rect;
        }
        return defaultValue;
    }

    private float sel(float height, float value, NSTextAlignment.Vertical alignment) {
        switch (alignment) {
            case BOTTOM: {
                return height - value;
            }
            case CENTER: {
                return (height - value) / 2.0f;
            }
        }
        return 0.0f;
    }

    private float sel(float width, float value, NSTextAlignment.Horizontal alignment) {
        switch (alignment) {
            case RIGHT: {
                return width - value;
            }
            case CENTER: {
                return (width - value) / 2.0f;
            }
        }
        return 0.0f;
    }
}

