/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.impl.ObjectUtilsImpl;
import com.apple.library.uikit.UIView;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public interface ViewImpl {
    public UIView self();

    public CGPoint center();

    public CGRect bounds();

    public CGAffineTransform transform();

    default public CGPoint convertPointFromView(CGPoint point, @Nullable UIView view) {
        CGAffineTransform transform = this._computeTransformInViewHierarchy(view, false);
        if (transform != null) {
            return point.applying(transform);
        }
        return point;
    }

    default public CGPoint convertPointToView(CGPoint point, @Nullable UIView view) {
        CGAffineTransform transform = this._computeTransformInViewHierarchy(view, true);
        if (transform != null) {
            return point.applying(transform);
        }
        return point;
    }

    default public CGRect convertRectFromView(CGRect rect, @Nullable UIView view) {
        CGAffineTransform transform = this._computeTransformInViewHierarchy(view, false);
        if (transform != null) {
            return rect.applying(transform);
        }
        return rect;
    }

    default public CGRect convertRectToView(CGRect rect, @Nullable UIView view) {
        CGAffineTransform transform = this._computeTransformInViewHierarchy(view, true);
        if (transform != null) {
            return rect.applying(transform);
        }
        return rect;
    }

    @Nullable
    default public CGAffineTransform _computeTransformInViewHierarchy(@Nullable UIView searchedView, boolean reversed) {
        if (searchedView == null) {
            searchedView = this.self().window();
        }
        if (searchedView == this) {
            return null;
        }
        Iterable enumerator = null;
        LinkedList<ViewImpl> results = this._searchInViewHierarchy(searchedView);
        if (results != null) {
            enumerator = results::descendingIterator;
        }
        if (enumerator == null && searchedView != null) {
            results = searchedView._searchInViewHierarchy(this.self());
            if (results == null) {
                return null;
            }
            results.removeFirst();
            results.add(searchedView);
            reversed = !reversed;
            enumerator = results;
        }
        if (enumerator == null) {
            return null;
        }
        float tx = 0.0f;
        float ty = 0.0f;
        CGAffineTransform translate = CGAffineTransform.createScale(1.0f, 1.0f);
        for (ViewImpl view : enumerator) {
            CGAffineTransform transform = view.transform();
            CGPoint center = view.center();
            CGRect bounds = view.bounds();
            tx += center.x;
            ty += center.y;
            tx -= bounds.x;
            ty -= bounds.y;
            if (transform.isIdentity()) {
                tx -= bounds.width * 0.5f;
                ty -= bounds.height * 0.5f;
                continue;
            }
            CGSize size = bounds.size();
            size.apply(transform);
            CGAffineTransform tmp = CGAffineTransform.createTranslation(-(tx -= size.width * 0.5f), -(ty -= size.height * 0.5f));
            tmp.concat(view._invertedTransform());
            translate.concat(tmp);
            tx = 0.0f;
            ty = 0.0f;
        }
        if (tx != 0.0f || ty != 0.0f) {
            translate.concat(CGAffineTransform.createTranslation(-tx, -ty));
        }
        if (reversed) {
            translate.invert();
        }
        return translate;
    }

    @Nullable
    default public LinkedList<ViewImpl> _searchInViewHierarchy(UIView searchedView) {
        LinkedList<ViewImpl> results = new LinkedList<ViewImpl>();
        ViewImpl searchingView = this;
        while (searchingView != null && searchingView.self() != searchedView) {
            results.add(searchingView);
            searchingView = this._superviewInViewHierarchy(searchingView);
        }
        UIView searchingView1 = ObjectUtilsImpl.flatMap(searchingView, ViewImpl::self);
        if (searchingView1 == searchedView) {
            return results;
        }
        return null;
    }

    default public ViewImpl _superviewInViewHierarchy(ViewImpl searchingView) {
        return searchingView.self().superview();
    }

    default public CGAffineTransform _invertedTransform() {
        return this.transform().inverted();
    }

    default public boolean _ignoresTouchEvents(UIView view) {
        return !view.isUserInteractionEnabled() || view.isHidden();
    }

    default public float[] _applyAutoresizingMask(float offset, float size, float newValue, float oldValue, int mask) {
        float newOffset = offset;
        float newSize = size;
        switch (mask & 7) {
            case 1: {
                newOffset = newValue - (oldValue - offset);
                break;
            }
            case 2: {
                newSize = newValue - (oldValue - size);
                break;
            }
            case 3: {
                float usage = 0.5f;
                if (offset != 0.0f || size != 0.0f) {
                    usage = offset / (offset + size);
                }
                float dx = oldValue - offset - size;
                newOffset = (newValue - dx) * usage;
                newSize = newValue - dx - newOffset;
                break;
            }
            case 5: {
                float usage = 0.5f;
                if (oldValue != size) {
                    usage = offset / (oldValue - size);
                }
                newOffset = (newValue - size) * usage;
                break;
            }
            case 6: {
                float usage = 1.0f;
                if (oldValue != size) {
                    usage = size / (oldValue - size);
                }
                newSize = (newValue - offset) * usage;
                break;
            }
            case 7: {
                float usage1;
                float usage2 = usage1 = 0.33333334f;
                if (oldValue != 0.0f) {
                    usage1 = offset / oldValue;
                    usage2 = size / oldValue;
                }
                newOffset = newValue * usage1;
                newSize = newValue * usage2;
                break;
            }
        }
        return new float[]{newOffset, Math.max(newSize, 0.0f)};
    }
}

