/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.SoundManagerImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UILabel;

public class UICheckBox
extends UIControl {
    private final UILabel markerView = new UILabel(new CGRect(1.0f, 0.0f, 9.0f, 9.0f));
    private final UILabel titleView = new UILabel(CGRect.ZERO);

    public UICheckBox(CGRect frame) {
        super(frame);
        UIImageView imageView = new UIImageView(new CGRect(0.0f, 0.0f, 9.0f, 9.0f));
        imageView.setImage(AppearanceImpl.BUTTON_IMAGE.imageAtIndex(4));
        this.addSubview(imageView);
        this.markerView.setText(new NSString("x"));
        this.markerView.setTextColor(UIColor.WHITE);
        this.markerView.setTextHorizontalAlignment(NSTextAlignment.Horizontal.CENTER);
        this.addSubview(this.markerView);
        this.addSubview(this.titleView);
        this.setSelected(false);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect rect = this.bounds();
        this.titleView.setFrame(rect.insetBy(0.0f, 10.0f, 0.0f, 0.0f));
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        if (!this.isEnabled()) {
            return;
        }
        this.setSelected(!this.isSelected());
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
        SoundManagerImpl.click();
    }

    public NSString title() {
        return this.titleView.text();
    }

    public void setTitle(NSString title) {
        this.titleView.setText(title);
    }

    public UIColor titleColor() {
        return this.titleView.textColor();
    }

    public void setTitleColor(UIColor color) {
        this.titleView.setTextColor(color);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (!isEnabled) {
            this.titleView.setTextColor(new UIColor(0xA0A0A0));
        } else {
            this.titleView.setTextColor(null);
        }
    }

    @Override
    public void setSelected(boolean isSelected) {
        super.setSelected(isSelected);
        this.markerView.setHidden(!isSelected);
    }
}

