/*
 * Decompiled with CFR 0.152.
 */
package extensions.net.minecraft.core.Registry;

import com.mojang.brigadier.CommandDispatcher;
import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.level.block.entity.BlockEntity.DataProvider;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.ThisClass;
import moe.plushie.armourers_workshop.builder.block.SkinCubeBlock;
import moe.plushie.armourers_workshop.compatibility.AbstractArgumentTypeInfo;
import moe.plushie.armourers_workshop.init.platform.forge.NotificationCenterImpl;
import moe.plushie.armourers_workshop.init.provider.CommonNativeProvider;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.event.server.ServerLifecycleEvent;

@Extension
public class CommonEventProvider {
    public static void willServerTickFO(@ThisClass Class<?> clazz, Consumer<ServerWorld> consumer) {
        NotificationCenterImpl.observer(TickEvent.WorldTickEvent.class, event -> {
            if (event.side == LogicalSide.SERVER) {
                consumer.accept((ServerWorld)event.world);
            }
        });
    }

    public static void willServerStartFO(@ThisClass Class<?> clazz, Consumer<MinecraftServer> consumer) {
        NotificationCenterImpl.observer(FMLServerAboutToStartEvent.class, consumer, ServerLifecycleEvent::getServer);
    }

    public static void didServerStartFO(@ThisClass Class<?> clazz, Consumer<MinecraftServer> consumer) {
        NotificationCenterImpl.observer(FMLServerStartedEvent.class, consumer, ServerLifecycleEvent::getServer);
    }

    public static void willServerStopFO(@ThisClass Class<?> clazz, Consumer<MinecraftServer> consumer) {
        NotificationCenterImpl.observer(FMLServerStoppingEvent.class, consumer, ServerLifecycleEvent::getServer);
    }

    public static void didServerStopFO(@ThisClass Class<?> clazz, Consumer<MinecraftServer> consumer) {
        NotificationCenterImpl.observer(FMLServerStoppedEvent.class, consumer, ServerLifecycleEvent::getServer);
    }

    public static void willPlayerLoginFO(@ThisClass Class<?> clazz, Consumer<PlayerEntity> consumer) {
        NotificationCenterImpl.observer(PlayerEvent.PlayerLoggedInEvent.class, consumer, PlayerEvent::getPlayer);
    }

    public static void willPlayerLogoutFO(@ThisClass Class<?> clazz, Consumer<PlayerEntity> consumer) {
        NotificationCenterImpl.observer(PlayerEvent.PlayerLoggedOutEvent.class, consumer, PlayerEvent::getPlayer);
    }

    public static void willPlayerCloneFO(@ThisClass Class<?> clazz, BiConsumer<PlayerEntity, PlayerEntity> consumer) {
        NotificationCenterImpl.observer(PlayerEvent.Clone.class, event -> consumer.accept(event.getOriginal(), event.getPlayer()));
    }

    public static void didTackingEntityFO(@ThisClass Class<?> clazz, BiConsumer<Entity, PlayerEntity> consumer) {
        NotificationCenterImpl.observer(PlayerEvent.StartTracking.class, event -> consumer.accept(event.getTarget(), event.getPlayer()));
    }

    public static void shouldAttackEntityFO(@ThisClass Class<?> clazz, BiFunction<Entity, PlayerEntity, ActionResultType> consumer) {
        NotificationCenterImpl.observer(AttackEntityEvent.class, event -> {
            if (consumer.apply(event.getTarget(), event.getPlayer()) == ActionResultType.FAIL) {
                event.setCanceled(true);
            }
        });
    }

    public static void willDropEntityFO(@ThisClass Class<?> clazz, Consumer<Entity> consumer) {
        NotificationCenterImpl.observer(LivingDropsEvent.class, consumer, EntityEvent::getEntity);
    }

    public static void didJoinEntityFO(@ThisClass Class<?> clazz, Consumer<Entity> consumer) {
        NotificationCenterImpl.observer(EntityJoinWorldEvent.class, event -> {
            if (!event.getWorld().func_201670_d()) {
                consumer.accept(event.getEntity());
            }
        });
    }

    public static void willBlockPlaceFO(@ThisClass Class<?> clazz, CommonNativeProvider.BlockSnapshot consumer) {
        NotificationCenterImpl.observer(BlockEvent.EntityPlaceEvent.class, event -> {
            Block block = event.getState().func_177230_c();
            if (event.getEntity() instanceof ServerPlayerEntity && block instanceof SkinCubeBlock) {
                PlayerEntity player = (PlayerEntity)event.getEntity();
                IWorld level = event.getWorld();
                BlockState oldState = event.getBlockSnapshot().getReplacedBlock();
                CompoundNBT oldTag = event.getBlockSnapshot().getNbt();
                IFormattableTextComponent reason = TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.placeBlock", new Object[0]);
                consumer.snapshot(level, event.getPos(), oldState, oldTag, player, (ITextComponent)reason);
            }
        });
    }

    public static void willBlockBreakFO(@ThisClass Class<?> clazz, CommonNativeProvider.BlockSnapshot consumer) {
        NotificationCenterImpl.observer(BlockEvent.BreakEvent.class, event -> {
            Block block = event.getState().func_177230_c();
            if (event.getPlayer() instanceof ServerPlayerEntity && block instanceof SkinCubeBlock) {
                IWorld level = event.getWorld();
                TileEntity blockEntity = level.func_175625_s(event.getPos());
                CompoundNBT oldNBT = null;
                if (blockEntity != null) {
                    oldNBT = DataProvider.saveWithFullMetadata(blockEntity);
                }
                IFormattableTextComponent reason = TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.breakBlock", new Object[0]);
                consumer.snapshot(level, event.getPos(), event.getState(), oldNBT, event.getPlayer(), (ITextComponent)reason);
            }
        });
    }

    public static void willConfigReloadFO(@ThisClass Class<?> clazz, Consumer<ForgeConfigSpec> consumer) {
        NotificationCenterImpl.observer(ModConfig.ModConfigEvent.class, event -> {
            ForgeConfigSpec spec = ObjectUtils.safeCast(event.getConfig().getSpec(), ForgeConfigSpec.class);
            if (spec != null) {
                consumer.accept(spec);
            }
        });
    }

    public static void willRegisterEntityAttributesFO(@ThisClass Class<?> clazz, Consumer<CommonNativeProvider.EntityAttributesRegistry> consumer) {
        NotificationCenterImpl.observer(EntityAttributeCreationEvent.class, consumer, event -> (entity, builder) -> event.put(entity, builder.func_233813_a_()));
    }

    public static void willRegisterCustomDataPackFO(@ThisClass Class<?> clazz, Supplier<IFutureReloadListener> consumer) {
        NotificationCenterImpl.observer(AddReloadListenerEvent.class, event -> event.addListener((IFutureReloadListener)consumer.get()));
    }

    public static void willRegisterCommandFO(@ThisClass Class<?> clazz, Consumer<CommandDispatcher<CommandSource>> consumer) {
        NotificationCenterImpl.observer(RegisterCommandsEvent.class, consumer, RegisterCommandsEvent::getDispatcher);
    }

    public static void willRegisterArgumentFO(@ThisClass Class<?> clazz, Consumer<CommonNativeProvider.ArgumentRegistry> consumer) {
        consumer.accept(AbstractArgumentTypeInfo::register);
    }
}

