/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.item.impl.IPaintProvider;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;

public class ColorMixerBlockEntity
extends UpdatableBlockEntity
implements IPaintProvider {
    private IPaintColor color = PaintColor.WHITE;

    public ColorMixerBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.color = DataSerializers.getPaintColor(nbt, "Color", PaintColor.WHITE);
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        DataSerializers.putPaintColor(nbt, "Color", this.color, PaintColor.WHITE);
    }

    @Override
    public IPaintColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(IPaintColor color) {
        this.color = color;
        BlockUtils.combine(this, this::sendBlockUpdates);
    }
}

