/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIBarItem;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIScreen;
import com.apple.library.uikit.UIView;
import java.util.HashMap;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedSkinBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel.AdvancedBoneSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel.AdvancedCameraSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel.AdvancedGeneralSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel.AdvancedSkinPanel;
import moe.plushie.armourers_workshop.builder.client.gui.widget.DrawerToolbar;
import moe.plushie.armourers_workshop.builder.client.gui.widget.Shortcut;
import moe.plushie.armourers_workshop.builder.menu.AdvancedSkinBuilderMenu;
import moe.plushie.armourers_workshop.compatibility.client.AbstractMenuWindowProvider;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeNode;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeView;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedSkinBuilderWindow
extends MenuWindow<AdvancedSkinBuilderMenu> {
    private final AdvancedCameraSkinPanel cameraView;
    private final AdvancedSkinBuilderBlockEntity blockEntity;
    private final UIView rightCard = new UIView(CGRect.ZERO);
    private final TreeView rightTree = new TreeView(new CGRect(0.0f, 0.0f, 200.0f, 200.0f));
    private final DrawerToolbar rightToolbar = new DrawerToolbar(new CGRect(0.0f, 0.0f, 200.0f, 480.0f));
    private final HashMap<Shortcut, Runnable> shortcuts = new HashMap();
    private int leftCardOffset = 100;
    private int rightCardOffset = 100;
    public static AbstractMenuWindowProvider<AdvancedSkinBuilderMenu, AdvancedSkinBuilderWindow> PROVIDER;

    public static AdvancedSkinBuilderWindow create(AdvancedSkinBuilderMenu container, PlayerInventory inventory, NSString title) {
        if (PROVIDER != null) {
            return PROVIDER.create(container, inventory, title);
        }
        return new AdvancedSkinBuilderWindow(container, inventory, title);
    }

    public AdvancedSkinBuilderWindow(AdvancedSkinBuilderMenu container, PlayerInventory inventory, NSString title) {
        super(container, inventory, title);
        this.blockEntity = container.getBlockEntity(AdvancedSkinBuilderBlockEntity.class);
        this.cameraView = new AdvancedCameraSkinPanel(this.blockEntity);
        this.inventoryView.setHidden(true);
        this.setup();
        this.reloadData();
        this.cameraView.reset();
    }

    private void setup() {
        CGRect bounds = UIScreen.bounds();
        this.setFrame(bounds);
        this.setupCameraView();
        this.setupRightCard(bounds);
        this.setupShortcuts();
    }

    private void setupCameraView() {
        this.cameraView.setFrame(this.bounds());
        this.cameraView.setAutoresizingMask(18);
        this.addSubview(this.cameraView);
    }

    private void setupRightCard(CGRect rect) {
        float w = 200.0f;
        float h = rect.height * 2.0f;
        float h1 = h * 0.35f;
        float h2 = h * 0.65f;
        this.rightCard.setFrame(new CGRect(0.0f, 0.0f, w, h));
        this.rightCard.setAutoresizingMask(17);
        this.rightCard.setBackgroundColor(new UIColor(0x1D1D1D));
        this.addSubview(this.rightCard);
        UIImage image = UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(24.0f, 24.0f).fixed(24.0f, 24.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build();
        UIView bg1 = new UIView(this.rightCard.bounds().insetBy(4.0f, 4.0f, h2, 4.0f));
        bg1.setContents(image);
        bg1.setAutoresizingMask(34);
        this.rightCard.addSubview(bg1);
        UILabel typeView = new UILabel(new CGRect(24.0f, 0.0f, bg1.bounds().getWidth() - 24.0f, 24.0f));
        typeView.setText(new NSString("General - Outfit"));
        typeView.setTextColor(UIColor.WHITE);
        typeView.setAutoresizingMask(34);
        bg1.addSubview(typeView);
        this.rightTree.setFrame(bg1.bounds().insetBy(24.0f, 0.0f, 0.0f, 0.0f));
        this.rightTree.setAutoresizingMask(18);
        bg1.addSubview(this.rightTree);
        UIView bg2 = new UIView(this.rightCard.bounds().insetBy(h1 + 4.0f, 4.0f, 4.0f, 4.0f));
        bg2.setAutoresizingMask(18);
        bg2.setContents(image);
        this.rightCard.addSubview(bg2);
        this.rightToolbar.setFrame(bg2.bounds().insetBy(0.0f, 0.0f, 0.0f, 0.0f));
        this.rightToolbar.setAutoresizingMask(18);
        bg2.addSubview(this.rightToolbar);
        this.addRightPanel(new AdvancedGeneralSkinPanel(this.blockEntity));
        this.addRightPanel(new AdvancedBoneSkinPanel(this.blockEntity));
        this.rightCard.setTransform(CGAffineTransform.createScale(0.5f, 0.5f));
        this.rightCard.setFrame(new CGRect(rect.width - (float)this.rightCardOffset, 0.0f, this.rightCardOffset, rect.height));
    }

    private void setupShortcuts() {
        this.shortcuts.put(Shortcut.of("key.keyboard.control", "key.keyboard.1"), this::toggleLeftCard);
        this.shortcuts.put(Shortcut.of("key.keyboard.control", "key.keyboard.2"), this::toggleRightCard);
    }

    private void reloadData() {
        TreeNode rootNode = this.rightTree.rootNode();
        this.addToNode(rootNode, "Root", 10);
        this.addToNode(rootNode.nodeAtIndex(0), "First", 10);
        this.addToNode(rootNode.nodeAtIndex(1), "Second", 10);
        this.addToNode(rootNode.nodeAtIndex(3), "Thriii", 10);
        this.addToNode(rootNode.nodeAtIndex(0).nodeAtIndex(0), "Children", 10);
    }

    private void toggleLeftCard() {
        ModLog.debug("{}", "show left card");
    }

    private void toggleRightCard() {
        ModLog.debug("{}", "show right card");
        CGPoint oldValue = this.rightCard.center();
        CGPoint newValue = new CGPoint(oldValue.x + (float)this.rightCardOffset, oldValue.y);
        UIView.animationWithDuration(0.35, () -> this.rightCard.setCenter(newValue));
        this.rightCardOffset = -this.rightCardOffset;
    }

    protected void addRightPanel(AdvancedSkinPanel panel) {
        UIBarItem barItem = panel.barItem();
        panel.setFrame(this.rightToolbar.bounds());
        panel.sizeToFit();
        this.rightToolbar.addPage(panel, barItem);
    }

    protected void addToNode(TreeNode node, String prefix, int count) {
        for (int i = 0; i < count; ++i) {
            node.add(new TreeNode(new NSString(prefix + " - " + i)));
        }
    }

    @Override
    public void init() {
        super.init();
        this.cameraView.connect();
    }

    @Override
    public void deinit() {
        super.deinit();
        this.cameraView.disconnect();
    }

    @Override
    public void screenWillResize(CGSize size) {
        this.setFrame(new CGRect(0.0f, 0.0f, size.width, size.height));
    }

    @Override
    public void keyDown(UIEvent event) {
        super.keyDown(event);
        int key1 = event.key();
        int key2 = event.keyModifier();
        this.shortcuts.forEach((key, handler) -> {
            if (key.matches(key1, key2)) {
                handler.run();
            }
        });
    }

    @Override
    public boolean shouldRenderBackground() {
        return false;
    }
}

