/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.KeyboardManagerImpl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.net.minecraft.client.Options.FOVSupport;
import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedSkinBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.render.AdvancedSkinBuilderBlockEntityRenderer;
import moe.plushie.armourers_workshop.builder.entity.CameraEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.utils.math.ClamppedVector3f;
import moe.plushie.armourers_workshop.utils.math.OpenAABB;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenNearPlane;
import moe.plushie.armourers_workshop.utils.math.OpenRay;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;

public class AdvancedCameraSkinPanel
extends UIView {
    private CGPoint startMousePos = CGPoint.ZERO;
    private final Vector3f origin = new Vector3f();
    private final Vector3f oldRotation = new Vector3f();
    private final Vector3f oldTranslate = new Vector3f();
    private final ClamppedVector3f lastScale = new ClamppedVector3f(1.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 5.0f, 5.0f, 5.0f);
    private final ClamppedVector3f lastRotation = new ClamppedVector3f(0.0f, 0.0f, 0.0f, -90.0f, Float.NEGATIVE_INFINITY, 0.0f, 90.0f, Float.POSITIVE_INFINITY, 0.0f);
    private final ClamppedVector3f lastTranslate = new ClamppedVector3f(0.0f, 0.0f, 0.0f, -8.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f);
    private final GameSettings options;
    private final AdvancedSkinBuilderBlockEntity blockEntity;
    private final CameraEntity cameraEntity = new CameraEntity();
    private Collection<Node> cachedTree;
    boolean moveMode = false;
    boolean rotationMode = false;

    public AdvancedCameraSkinPanel(AdvancedSkinBuilderBlockEntity blockEntity) {
        super(CGRect.ZERO);
        this.options = Minecraft.func_71410_x().field_71474_y;
        this.blockEntity = blockEntity;
    }

    public void connect() {
        this.cameraEntity.connect();
        this.reset();
    }

    public void disconnect() {
        this.reset();
        this.cameraEntity.disconnect();
    }

    public void reset() {
        this.origin.set(this.blockEntity.getRenderOrigin());
        this.lastRotation.set(0.0f, 0.0f, 0.0f);
        this.lastTranslate.set(0.0f, 0.0f, 0.0f);
        this.lastScale.set(1.0f, 1.0f, 1.0f);
        this.applyCameraChanges();
    }

    @Override
    public void mouseDown(UIEvent event) {
        boolean bl = this.rotationMode = event.type() != UIEvent.Type.MOUSE_RIGHT_DOWN;
        if (KeyboardManagerImpl.hasSpaceDown()) {
            this.rotationMode = !this.rotationMode;
        }
        this.moveMode = !this.rotationMode;
        this.startMousePos = event.locationInWindow();
        this.oldRotation.set(this.lastRotation);
        this.oldTranslate.set(this.lastTranslate);
    }

    @Override
    public void mouseUp(UIEvent event) {
        this.oldRotation.set(this.lastRotation);
        this.oldTranslate.set(this.lastTranslate);
    }

    @Override
    public void mouseDragged(UIEvent event) {
        CGPoint mousePos = event.locationInWindow();
        if (this.moveMode) {
            float dx = mousePos.x - this.startMousePos.x;
            float dy = mousePos.y - this.startMousePos.y;
            this.move(new Vector3f(dx, dy, 0.0f));
        }
        if (this.rotationMode) {
            this.rotation(mousePos);
        }
        this.applyCameraChanges();
    }

    @Override
    public void mouseWheel(UIEvent event) {
        if (KeyboardManagerImpl.hasControlDown()) {
            this.zoom(event.delta());
        } else {
            double delta = event.delta();
            if (delta < 0.0) {
                this.move(new Vector3f(0.0f, 0.0f, 0.95f));
            } else if (delta > 0.0) {
                this.move(new Vector3f(0.0f, 0.0f, -0.95f));
            }
            this.oldTranslate.set(this.lastTranslate);
        }
        this.applyCameraChanges();
    }

    @Override
    public void mouseMoved(UIEvent event) {
        this.raycast(event);
    }

    private void move(Vector3f delta) {
        CGRect window = this.bounds();
        OpenNearPlane plane = this.cameraEntity.getNearPlane();
        float near = FOVSupport.getCameraNear(this.options);
        float deltaX = -delta.getX() / (window.width / 2.0f);
        float deltaY = delta.getY() / (window.height / 2.0f);
        float deltaZ = near + delta.getZ();
        Vector3f d1 = plane.at(0.0f, 0.0f, -near);
        Vector3f d2 = plane.at(deltaX, deltaY, deltaZ);
        float x = this.oldTranslate.getX() + d1.getX() + d2.getX();
        float y = this.oldTranslate.getY() + d1.getY() + d2.getY();
        float z = this.oldTranslate.getZ() + d1.getZ() + d2.getZ();
        this.lastTranslate.set(x, y, z);
    }

    private void rotation(CGPoint mousePos) {
        CGRect window = this.bounds();
        float dx = (mousePos.y - this.startMousePos.y) / window.height;
        float dy = (mousePos.x - this.startMousePos.x) / window.width;
        float rx = this.oldRotation.getX() + dx * 360.0f;
        float ry = this.oldRotation.getY() + dy * 360.0f;
        this.lastRotation.set(rx, ry, 0.0f);
    }

    private void zoom(double delta) {
        float scale = this.lastScale.getX();
        if (delta < 0.0) {
            scale *= 0.95f;
        } else if (delta > 0.0) {
            scale /= 0.95f;
        }
        this.lastScale.set(scale, scale, scale);
        this.cachedTree = null;
    }

    private void raycast(UIEvent event) {
        CGRect window = this.bounds();
        CGPoint mousePos = event.locationInWindow();
        float deltaX = (mousePos.x - window.width / 2.0f) / (window.width / 2.0f);
        float deltaY = -(mousePos.y - window.height / 2.0f) / (window.height / 2.0f);
        float deltaZ = FOVSupport.getCameraNear(this.options);
        OpenNearPlane plane = this.cameraEntity.getNearPlane();
        Vector3f d1 = plane.at(0.0f, 0.0f, -deltaZ);
        Vector3f d2 = plane.at(deltaX, deltaY, deltaZ);
        Vector3f location = this.lastTranslate.adding(this.origin);
        Vector3f hit = location.adding(d1).adding(d2);
        Vector3f origin = location.adding(d1);
        Vector3f direction = hit.subtracting(origin).normalizing();
        OpenRay ray = new OpenRay(origin, direction);
        ArrayList<Result> results = new ArrayList<Result>();
        this.buildPickTree().forEach(node -> node.raycast(ray, results::add));
        if (results.isEmpty()) {
            AdvancedSkinBuilderBlockEntityRenderer.setResult(Collections.emptyList());
        } else {
            results.sort(Comparator.comparing(it -> Float.valueOf(it.distance)));
            AdvancedSkinBuilderBlockEntityRenderer.setResult(Collections.singleton(((Result)results.get((int)0)).part));
        }
    }

    public Collection<Node> buildPickTree() {
        if (this.cachedTree != null) {
            return this.cachedTree;
        }
        AdvancedSkinBuilderBlockEntity entity = this.blockEntity;
        SkinRenderTesselator tesselator = SkinRenderTesselator.create(entity.descriptor, Tickets.TEST);
        if (tesselator == null) {
            return Collections.emptyList();
        }
        ArrayList<Node> allNodes = new ArrayList<Node>();
        MatrixStack poseStack = new MatrixStack();
        Vector3f pos = entity.getRenderOrigin();
        Vector3f scale = entity.carmeScale;
        poseStack.func_227861_a_((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        poseStack.func_227862_a_(scale.getX(), scale.getY(), scale.getZ());
        poseStack.func_227862_a_(-0.0625f, -0.0625f, 0.0625f);
        tesselator.setLightmap(0xF000F0);
        tesselator.setPartialTicks(0.0f);
        tesselator.setBuffer(skin -> (bakedPart, bakedSkin, scheme, shouldRender, context) -> {
            if (shouldRender) {
                OpenMatrix4f mat = new OpenMatrix4f(context.pose().lastPose());
                mat.invert();
                allNodes.add(new Node(bakedPart, mat));
            }
            return 0;
        });
        tesselator.draw(poseStack, null);
        this.cachedTree = allNodes;
        return allNodes;
    }

    public void applyCameraChanges() {
        float tx = this.lastTranslate.getX();
        float ty = this.lastTranslate.getY();
        float tz = this.lastTranslate.getZ();
        float rx = this.lastRotation.getX();
        float ry = this.lastRotation.getY();
        float rz = this.lastRotation.getZ();
        float sx = this.lastScale.getX();
        float sy = this.lastScale.getY();
        float sz = this.lastScale.getZ();
        this.blockEntity.carmeOffset.set(tx, ty, tz);
        this.blockEntity.carmeRot.set(rx, ry, rz);
        this.blockEntity.carmeScale.set(sx, sy, sz);
        PropertyProvider.setXRot((Entity)this.cameraEntity, rx);
        PropertyProvider.setYRot((Entity)this.cameraEntity, ry);
        this.cameraEntity.func_70107_b(this.origin.getX() + tx, this.origin.getY() + ty, this.origin.getZ() + tz);
        PropertyProvider.setOldPosAndRot((Entity)this.cameraEntity);
    }

    public static class Result {
        final BakedSkinPart part;
        float distance;

        Result(BakedSkinPart part, float distance) {
            this.part = part;
            this.distance = distance;
        }
    }

    public static class Node {
        final OpenMatrix4f invMat;
        final BakedSkinPart part;
        final OpenAABB box;

        Node(BakedSkinPart part, OpenMatrix4f invMat) {
            this.part = part;
            this.invMat = invMat;
            this.box = part.getRenderShape().aabb();
        }

        public void raycast(OpenRay ray, Consumer<Result> recorder) {
            OpenRay ray1 = ray.transforming(this.invMat);
            if (!this.box.intersects(ray1)) {
                return;
            }
            Result[] result = new Result[]{null};
            this.part.forEach(ray1, face -> {
                float distance = ray1.origin.distanceToSquared(new Vector3f(face.x, face.y, face.z));
                if (result[0] == null) {
                    result[0] = new Result(this.part, distance);
                } else {
                    result[0].distance = Math.min(result[0].distance, distance);
                }
            });
            if (result[0] != null) {
                recorder.accept(result[0]);
            }
        }
    }
}

