/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateArmourerPacket;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinComboBox;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerMainSetting
extends ArmourerBaseSetting
implements UITextFieldDelegate {
    private final UITextField nameTextField = new UITextField(new CGRect(8.0f, 58.0f, 158.0f, 16.0f));
    private final UITextField flavorTextField = new UITextField(new CGRect(8.0f, 90.0f, 158.0f, 16.0f));
    private final SkinComboBox skinTypeBox = new SkinComboBox(new CGRect(7.0f, 21.0f, 50.0f, 16.0f));
    protected final ArmourerMenu container;
    protected final ArmourerBlockEntity blockEntity;
    protected final String modVersion;
    protected ISkinType skinType = SkinTypes.ARMOR_HEAD;

    protected ArmourerMainSetting(ArmourerMenu container) {
        super("inventory.armourers_workshop.armourer.main");
        this.modVersion = EnvironmentManager.getVersion();
        this.container = container;
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
        if (this.blockEntity != null) {
            this.skinType = this.blockEntity.getSkinType();
        }
    }

    private static List<ISkinType> getSkinTypes() {
        ArrayList<ISkinType> skinTypes = new ArrayList<ISkinType>();
        for (ISkinType skinType : SkinTypes.values()) {
            if (skinType == SkinTypes.UNKNOWN || skinType == SkinTypes.OUTFIT) continue;
            skinTypes.add(skinType);
        }
        return skinTypes;
    }

    @Override
    public void init() {
        UIButton saveBtn = new UIButton(new CGRect(88.0f, 16.0f, 50.0f, 12.0f));
        saveBtn.setTitle(this.getDisplayText("save"), 7);
        saveBtn.setTitleColor(UIColor.WHITE, 7);
        saveBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        saveBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerMainSetting::saveSkin);
        this.addSubview(saveBtn);
        UIButton loadBtn = new UIButton(new CGRect(88.0f, 29.0f, 50.0f, 12.0f));
        loadBtn.setTitle(this.getDisplayText("load"), 7);
        loadBtn.setTitleColor(UIColor.WHITE, 7);
        loadBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        loadBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerMainSetting::loadSkin);
        this.addSubview(loadBtn);
        this.nameTextField.setMaxLength(40);
        this.nameTextField.setDelegate(this);
        this.addSubview(this.nameTextField);
        this.flavorTextField.setMaxLength(40);
        this.flavorTextField.setDelegate(this);
        this.addSubview(this.flavorTextField);
        this.setupLabel(14, 48, this.getDisplayText("label.itemName"));
        this.setupLabel(14, 80, this.getDisplayText("label.flavour"));
        if (this.modVersion != null) {
            UILabel modLabel = new UILabel(new CGRect(8.0f, 131.0f, 160.0f, 9.0f));
            modLabel.setText(new NSString(this.modVersion));
            modLabel.setTextHorizontalAlignment(NSTextAlignment.Horizontal.RIGHT);
            this.addSubview(modLabel);
        }
        this.setupHelpView(6, 12, "help.skinType");
        this.setupHelpView(6, 48, "help.itemName");
        this.setupHelpView(6, 80, "help.itemFlavour");
        this.setupHelpView(81, 18, "help.save");
        this.setupHelpView(81, 30, "help.load");
        this.skinTypeBox.setMaxRows(7);
        this.skinTypeBox.reloadSkins(ArmourerMainSetting.getSkinTypes());
        this.skinTypeBox.setSelectedSkin(this.skinType);
        this.skinTypeBox.addTarget(this, UIControl.Event.VALUE_CHANGED, ArmourerMainSetting::updateSkinType);
        this.addSubview(this.skinTypeBox);
        UIImageView slot1 = new UIImageView(new CGRect(63.0f, 20.0f, 18.0f, 18.0f));
        UIImageView slot2 = new UIImageView(new CGRect(142.0f, 16.0f, 26.0f, 26.0f));
        slot1.setImage(UIImage.of(ModTextures.ARMOURER).uv(238.0f, 0.0f).build());
        slot2.setImage(UIImage.of(ModTextures.ARMOURER).uv(230.0f, 18.0f).build());
        this.insertViewAtIndex(slot1, 0);
        this.insertViewAtIndex(slot2, 0);
        this.reloadData();
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.updateSkinPropertiesReturn();
        return true;
    }

    @Override
    public void textFieldDidEndEditing(UITextField textField) {
        this.updateSkinProperties();
    }

    @Override
    public void reloadData() {
        SkinProperties skinProperties = this.blockEntity.getSkinProperties();
        this.nameTextField.setText(skinProperties.get(SkinProperty.ALL_CUSTOM_NAME));
        this.flavorTextField.setText(skinProperties.get(SkinProperty.ALL_FLAVOUR_TEXT));
        this.skinTypeBox.setSelectedSkin(this.blockEntity.getSkinType());
    }

    private void setupLabel(int x, int y, NSString text) {
        UILabel label = new UILabel(new CGRect(x, y, this.bounds().getWidth(), 9.0f));
        label.setText(text);
        this.addSubview(label);
    }

    private void setupHelpView(int x, int y, String key) {
        UIButton button = new UIButton(new CGRect(x, y, 7.0f, 8.0f));
        button.setBackgroundImage(ModTextures.helpButtonImage(), 7);
        button.setTooltip(this.getDisplayText(key));
        button.setCanBecomeFocused(false);
        this.addSubview(button);
    }

    private void updateSkinType(UIControl control) {
        ISkinType skinType = this.skinTypeBox.selectedSkin();
        if (Objects.equals(skinType, this.skinType)) {
            return;
        }
        this.skinType = skinType;
        if (this.blockEntity == null) {
            return;
        }
        this.blockEntity.setSkinType(skinType);
        UpdateArmourerPacket.Field field = UpdateArmourerPacket.Field.SKIN_TYPE;
        UpdateArmourerPacket packet = new UpdateArmourerPacket(this.blockEntity, field, skinType);
        NetworkManager.sendToServer(packet);
    }

    private void updateSkinProperties() {
        SkinProperties skinProperties = SkinProperties.create(this.blockEntity.getSkinProperties());
        skinProperties.put(SkinProperty.ALL_CUSTOM_NAME, this.nameTextField.text());
        skinProperties.put(SkinProperty.ALL_FLAVOUR_TEXT, this.flavorTextField.text());
        if (skinProperties.equals(this.blockEntity.getSkinProperties())) {
            return;
        }
        this.blockEntity.setSkinProperties(skinProperties);
        UpdateArmourerPacket.Field field = UpdateArmourerPacket.Field.SKIN_PROPERTIES;
        UpdateArmourerPacket packet = new UpdateArmourerPacket(this.blockEntity, field, skinProperties);
        NetworkManager.sendToServer(packet);
    }

    private void loadSkin(UIControl sender) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !this.container.shouldLoadArmourItem((PlayerEntity)player)) {
            return;
        }
        UpdateArmourerPacket.Field field = UpdateArmourerPacket.Field.ITEM_LOAD;
        UpdateArmourerPacket packet = new UpdateArmourerPacket(this.blockEntity, field, new CompoundNBT());
        NetworkManager.sendToServer(packet);
    }

    private void saveSkin(UIControl sender) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !this.container.shouldSaveArmourItem((PlayerEntity)player)) {
            return;
        }
        GameProfile origin = Minecraft.func_71410_x().func_110432_I().func_148256_e();
        CompoundNBT nbt = DataSerializers.writeGameProfile(new CompoundNBT(), origin);
        UpdateArmourerPacket.Field field = UpdateArmourerPacket.Field.ITEM_SAVE;
        UpdateArmourerPacket packet = new UpdateArmourerPacket(this.blockEntity, field, nbt);
        NetworkManager.sendToServer(packet);
    }

    private void updateSkinPropertiesReturn() {
        this.nameTextField.resignFirstResponder();
        this.flavorTextField.resignFirstResponder();
    }
}

