/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerClearDialog
extends ConfirmDialog {
    final ArrayList<ISkinPartType> partTypes;
    private final UIComboBox partComboBox = new UIComboBox(new CGRect(0.0f, 0.0f, 80.0f, 14.0f));
    private final UICheckBox blockCheckBox = new UICheckBox(CGRect.ZERO);
    private final UICheckBox paintCheckBox = new UICheckBox(CGRect.ZERO);
    private final UICheckBox markersCheckBox = new UICheckBox(CGRect.ZERO);

    public ArmourerClearDialog(ArrayList<ISkinPartType> partTypes) {
        this.setFrame(new CGRect(0.0f, 0.0f, 240.0f, 140.0f));
        this.partTypes = partTypes;
        this.setup();
    }

    private void setup() {
        this.layoutIfNeeded();
        float width = this.bounds().width - 30.0f;
        float left = this.confirmButton.frame().getX() + 1.0f;
        float bottom = this.confirmButton.frame().getY() - 4.0f;
        this.blockCheckBox.setFrame(new CGRect(left, bottom - 22.0f, width, 9.0f));
        this.blockCheckBox.setTitle(this.getText("clearBlocks"));
        this.blockCheckBox.setSelected(true);
        this.addSubview(this.blockCheckBox);
        this.paintCheckBox.setFrame(new CGRect(left, bottom - 11.0f, width, 9.0f));
        this.paintCheckBox.setTitle(this.getText("clearPaint"));
        this.paintCheckBox.setSelected(true);
        this.addSubview(this.paintCheckBox);
        this.markersCheckBox.setFrame(new CGRect(left, bottom - 33.0f, width, 9.0f));
        this.markersCheckBox.setTitle(this.getText("clearMarkers"));
        this.markersCheckBox.setSelected(true);
        this.addSubview(this.markersCheckBox);
        this.partComboBox.setFrame(new CGRect(left, 20.0f, 80.0f, 14.0f));
        this.partComboBox.setSelectedIndex(0);
        this.partComboBox.reloadData(this.getItems(this.partTypes));
        this.addSubview(this.partComboBox);
    }

    public boolean isClearBlocks() {
        return this.blockCheckBox == null || this.blockCheckBox.isSelected();
    }

    public boolean isClearPaints() {
        return this.paintCheckBox == null || this.paintCheckBox.isSelected();
    }

    public boolean isClearMarkers() {
        return this.markersCheckBox == null || this.markersCheckBox.isSelected();
    }

    public ISkinPartType getSelectedPartType() {
        if (this.partTypes != null && this.partComboBox != null && this.partComboBox.selectedIndex() < this.partTypes.size()) {
            return this.partTypes.get(this.partComboBox.selectedIndex());
        }
        return SkinPartTypes.UNKNOWN;
    }

    private ArrayList<UIComboItem> getItems(ArrayList<ISkinPartType> partTypes) {
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        for (ISkinPartType partType : partTypes) {
            NSString title = partType != SkinPartTypes.UNKNOWN ? new NSString((ITextComponent)TranslateUtils.Name.of(partType)) : new NSString("*");
            items.add(new UIComboItem(title));
        }
        return items;
    }

    private NSString getText(String key) {
        return new NSString((ITextComponent)TranslateUtils.title("inventory.armourers_workshop.armourer.dialog.clear." + key, new Object[0]));
    }
}

