/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.KeyboardManagerImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.builder.client.gui.widget.PaletteBox;
import moe.plushie.armourers_workshop.builder.data.palette.Palette;
import moe.plushie.armourers_workshop.builder.data.palette.PaletteManager;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.HSBSliderBox;
import moe.plushie.armourers_workshop.core.client.gui.widget.InputDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.PaintColorView;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;

public abstract class PaletteEditingWindow<M extends Container>
extends MenuWindow<M>
implements UITextFieldDelegate {
    protected final HSBSliderBox[] sliders = new HSBSliderBox[]{null, null, null};
    protected final PaintColorView paintColorView = new PaintColorView(new CGRect(108.0f, 102.0f, 13.0f, 13.0f));
    protected final UITextField hexInputView = new UITextField(new CGRect(5.0f, 105.0f, 55.0f, 16.0f));
    protected final UIComboBox paintComboBox = new UIComboBox(new CGRect(164.0f, 32.0f, 86.0f, 14.0f));
    protected final UIComboBox paletteComboBox = new UIComboBox(new CGRect(164.0f, 62.0f, 86.0f, 14.0f));
    protected final PaletteBox paletteBox = new PaletteBox(new CGRect(166.0f, 80.0f, 82.0f, 42.0f));
    protected final PaletteManager paletteManager = PaletteManager.getInstance();
    protected ArrayList<Palette> palettes = new ArrayList();
    protected ArrayList<ISkinPaintType> paintTypes;

    public PaletteEditingWindow(M menu, PlayerInventory inventory, NSString title) {
        super(menu, inventory, title);
    }

    @Override
    public void deinit() {
        super.deinit();
        this.paletteManager.save();
    }

    protected abstract void submitColorChange(UIControl var1);

    protected void applyPaletteChange(UIControl button) {
        int index = this.paletteBox.getSelectedIndex();
        Palette palette = this.getSelectedPalette();
        if (palette != null) {
            if (!palette.isLocked() && KeyboardManagerImpl.hasShiftDown()) {
                palette.setColor(index, this.paintColorView.color());
                this.paletteManager.markDirty();
                return;
            }
            UIColor selectedColor = palette.getColor(index);
            if (selectedColor == null) {
                return;
            }
            this.setSelectedColor(selectedColor);
            this.submitColorChange(button);
        }
    }

    protected void applyColorChange(UIControl button) {
        this.setColorComponents(new float[]{this.sliders[0].getValue(), this.sliders[1].getValue(), this.sliders[2].getValue()});
    }

    protected abstract NSString getDisplayText(String var1, Object ... var2);

    protected void showNewPaletteDialog(UIControl button) {
        InputDialog alert = new InputDialog();
        alert.setTitle(this.getDisplayText("add_palette.title", new Object[0]));
        alert.setPlaceholder(this.getDisplayText("add_palette.enter_name", new Object[0]));
        alert.showInView(this, () -> {
            if (!alert.isCancelled()) {
                this.setSelectedPalette(this.paletteManager.addPalette(alert.value()));
                this.reloadPalettes();
            }
        });
    }

    protected void showRenamePaletteDialog(UIControl button) {
        Palette palette = this.getSelectedPalette();
        if (palette == null || palette.isLocked()) {
            return;
        }
        InputDialog alert = new InputDialog();
        alert.setTitle(this.getDisplayText("rename_palette.title", new Object[0]));
        alert.setPlaceholder(this.getDisplayText("rename_palette.enter_name", new Object[0]));
        alert.setValue(palette.getName());
        alert.showInView(this, () -> {
            if (!alert.isCancelled()) {
                String name = palette.getName();
                PaletteManager.getInstance().renamePalette(name, alert.value());
                this.reloadPalettes();
            }
        });
    }

    protected void showRemovePaletteDialog(UIControl button) {
        Palette palette = this.getSelectedPalette();
        if (palette == null || palette.isLocked()) {
            return;
        }
        ConfirmDialog alert = new ConfirmDialog();
        alert.setTitle(this.getDisplayText("remove_palette.title", new Object[0]));
        alert.setMessage(this.getDisplayText("remove_palette.message", palette.getName()));
        alert.showInView(this, () -> {
            if (!alert.isCancelled()) {
                String name = palette.getName();
                this.paletteManager.deletePalette(name);
                this.setSelectedPalette(this.paletteManager.getPalettes().iterator().next());
                this.reloadPalettes();
            }
        });
    }

    protected void reloadPalettes() {
        int selectedIndex = 0;
        this.palettes = new ArrayList();
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        for (Palette palette : PaletteManager.getInstance().getPalettes()) {
            UIComboItem item = new UIComboItem(new NSString(palette.getName()));
            if (palette == this.getSelectedPalette()) {
                selectedIndex = items.size();
            }
            items.add(item);
            this.palettes.add(palette);
        }
        this.paletteComboBox.setSelectedIndex(selectedIndex);
        this.paletteComboBox.reloadData(items);
        this.setSelectedPalette(this.palettes.get(selectedIndex));
    }

    @Override
    public void textFieldDidEndEditing(UITextField textField) {
        this.applyColorChange(textField);
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        String value = textField.text();
        if (value.matches("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$")) {
            this.setSelectedColor(UIColor.decode(value));
            this.submitColorChange(textField);
        }
        return true;
    }

    protected void setColorComponents(float[] values) {
        UIColor newValue = UIColor.getHSBColor(values[0], values[1], values[2]);
        this.paintColorView.setColor(newValue);
        for (HSBSliderBox slider : this.sliders) {
            slider.setValueWithComponents(values);
        }
        this.hexInputView.setText(String.format("#%02x%02x%02x", newValue.getRed(), newValue.getGreen(), newValue.getBlue()));
        if (this.hexInputView.isEditing()) {
            this.hexInputView.resignFirstResponder();
        }
    }

    public void setSelectedColor(UIColor selectedColor) {
        float[] values = UIColor.RGBtoHSB(selectedColor.getRed(), selectedColor.getGreen(), selectedColor.getBlue(), null);
        this.setColorComponents(values);
    }

    public UIColor getSelectedColor() {
        return this.paintColorView.color();
    }

    public void setSelectedPalette(Palette selectedPalette) {
        this.paletteManager.setCurrentPalette(selectedPalette);
        if (this.paletteBox != null) {
            this.paletteBox.setPalette(selectedPalette);
        }
    }

    public Palette getSelectedPalette() {
        return this.paletteManager.getCurrentPalette();
    }
}

