/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedSkinBuilderBlockEntity;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedSkinBuilderBlockEntityRenderer<T extends AdvancedSkinBuilderBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    public static ArrayList<Vector3f> OUTPUTS = new ArrayList();
    public static HashSet<BakedSkinPart> RESULTS = new HashSet();

    public static void setOutput(int i, Vector3f pt) {
        while (i >= OUTPUTS.size()) {
            OUTPUTS.add(Vector3f.ZERO);
        }
        OUTPUTS.set(i, pt);
    }

    public static void setResult(Collection<BakedSkinPart> results) {
        RESULTS.clear();
        RESULTS.addAll(results);
    }

    public AdvancedSkinBuilderBlockEntityRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public void render(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        SkinRenderTesselator tesselator = SkinRenderTesselator.create(((AdvancedSkinBuilderBlockEntity)entity).descriptor, Tickets.RENDERER);
        if (tesselator == null) {
            return;
        }
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)((AdvancedSkinBuilderBlockEntity)entity).offset.getX(), (double)((AdvancedSkinBuilderBlockEntity)entity).offset.getY(), (double)((AdvancedSkinBuilderBlockEntity)entity).offset.getZ());
        poseStack.func_227861_a_(0.5, 0.5, 0.5);
        poseStack.func_227862_a_(((AdvancedSkinBuilderBlockEntity)entity).carmeScale.getX(), ((AdvancedSkinBuilderBlockEntity)entity).carmeScale.getY(), ((AdvancedSkinBuilderBlockEntity)entity).carmeScale.getZ());
        poseStack.func_227862_a_(-0.0625f, -0.0625f, 0.0625f);
        tesselator.setLightmap(0xF000F0);
        tesselator.setPartialTicks(0.0f);
        tesselator.setBuffer(OutlineObjectBuilder.immediate(buffers));
        tesselator.draw(poseStack, buffers);
        poseStack.func_227865_b_();
        if (ModDebugger.advancedSkinBuilderBlock) {
            BlockState blockState = entity.func_195044_w();
            BlockPos pos = entity.func_174877_v();
            poseStack.func_227860_a_();
            poseStack.func_227861_a_((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            RenderSystem.drawBoundingBox(poseStack, ((AdvancedSkinBuilderBlockEntity)entity).getCustomRenderBoundingBox(blockState), UIColor.RED, buffers);
            Vector3f origin = ((AdvancedSkinBuilderBlockEntity)entity).getRenderOrigin();
            poseStack.func_227861_a_((double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
            RenderSystem.drawPoint(poseStack, Vector3f.ZERO, 1.0f, buffers);
            poseStack.func_227861_a_((double)((AdvancedSkinBuilderBlockEntity)entity).carmeOffset.getX(), (double)((AdvancedSkinBuilderBlockEntity)entity).carmeOffset.getY(), (double)((AdvancedSkinBuilderBlockEntity)entity).carmeOffset.getZ());
            RenderSystem.drawPoint(poseStack, Vector3f.ZERO, 1.0f, buffers);
            poseStack.func_227865_b_();
        }
        this.renderOutput(entity, partialTicks, poseStack, buffers, light, overlay);
    }

    public void renderOutput(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        BlockPos pos = entity.func_174877_v();
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        if (OUTPUTS.size() >= 2) {
            Vector3f pt1 = OUTPUTS.get(0);
            Vector3f pt2 = OUTPUTS.get(1);
            RenderSystem.drawLine(poseStack, pt1.getX(), pt1.getY(), pt1.getZ(), pt2.getX(), pt2.getY(), pt2.getZ(), UIColor.YELLOW, buffers);
        }
        poseStack.func_227865_b_();
    }

    @Override
    public int getViewDistance() {
        return 272;
    }

    public static class OutlineObjectBuilder
    implements SkinRenderBufferSource.ObjectBuilder {
        private final SkinRenderBufferSource.ObjectBuilder builder;

        public OutlineObjectBuilder(SkinRenderBufferSource.ObjectBuilder builder) {
            this.builder = builder;
        }

        public static SkinRenderBufferSource immediate(IRenderTypeBuffer buffers) {
            SkinRenderBufferSource source = SkinRenderBufferSource.immediate(buffers);
            return skin -> new OutlineObjectBuilder(source.getBuffer(skin));
        }

        @Override
        public int addPart(BakedSkinPart bakedPart, BakedSkin bakedSkin, ColorScheme scheme, boolean shouldRender, SkinRenderContext context) {
            int total = 0;
            if (RESULTS.contains(bakedPart)) {
                context.setOverlay(0x38FFFFFF);
                total = this.builder.addPart(bakedPart, bakedSkin, scheme, shouldRender, context);
                context.setOverlay(0);
            }
            if (total != 0) {
                shouldRender = false;
            }
            return this.builder.addPart(bakedPart, bakedSkin, scheme, shouldRender, context);
        }

        @Override
        public void addShape(Vector3f origin, SkinRenderContext context) {
            this.builder.addShape(origin, context);
        }

        @Override
        public void addShape(OpenVoxelShape shape, UIColor color, SkinRenderContext context) {
            this.builder.addShape(shape, color, context);
        }

        @Override
        public void addShape(ITransformf[] transforms, SkinRenderContext context) {
            this.builder.addShape(transforms, context);
        }
    }
}

