/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import extensions.net.minecraft.world.item.ItemStack.ABI;
import moe.plushie.armourers_workshop.api.painting.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.ExtendedFaceRenderer;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinCubeBlockEntityRenderer<T extends TileEntity>
extends AbstractBlockEntityRenderer<T> {
    private static float markerAlpha = 0.0f;
    private static long lastWorldTimeUpdate;

    public SkinCubeBlockEntityRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public static void updateAlpha(TileEntity blockEntity) {
        World level = blockEntity.func_145831_w();
        if (level == null || lastWorldTimeUpdate == level.func_82737_E()) {
            return;
        }
        lastWorldTimeUpdate = level.func_82737_E();
        if (SkinCubeBlockEntityRenderer.isPlayerHoldingPaintingTool()) {
            if ((markerAlpha += 0.25f) > 1.0f) {
                markerAlpha = 1.0f;
            }
        } else if ((markerAlpha -= 0.25f) < 0.0f) {
            markerAlpha = 0.0f;
        }
    }

    private static boolean isPlayerHoldingPaintingTool() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        ItemStack itemStack = player.func_184614_ca();
        if (itemStack.func_77973_b() instanceof IBlockPaintViewer) {
            return true;
        }
        if (ABI.is(itemStack, (Item)ModItems.COLOR_PICKER.get())) {
            return true;
        }
        return ABI.is(itemStack, (Item)ModItems.SOAP.get());
    }

    @Override
    public void func_225616_a_(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        SkinCubeBlockEntityRenderer.updateAlpha(entity);
        if (!(markerAlpha > 0.0f)) {
            return;
        }
        int alpha = (int)(markerAlpha * 255.0f);
        IVertexBuilder builder = buffers.getBuffer(SkinRenderType.IMAGE_MARKER);
        for (Direction direction : Direction.values()) {
            if (!((IPaintable)entity).shouldChangeColor(direction) || !((IPaintable)entity).hasColor(direction)) continue;
            IPaintColor paintColor = ((IPaintable)entity).getColor(direction);
            ExtendedFaceRenderer.renderMarker(0, 0, 0, direction, paintColor, alpha, light, overlay, poseStack, builder);
        }
    }
}

