/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.common.IItemColorProvider;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.painting.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.builder.item.AbstractPaintToolItem;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.network.UpdateColorPickerPacket;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.item.impl.IPaintProvider;
import moe.plushie.armourers_workshop.core.item.impl.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ColorPickerItem
extends AbstractPaintToolItem
implements IItemTintColorProvider,
IItemPropertiesProvider,
IItemColorProvider,
IPaintToolPicker,
IBlockPaintViewer {
    public ColorPickerItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return this.usePickTool(context);
    }

    @Override
    public ActionResultType usePickTool(World level, BlockPos pos, Direction dir, TileEntity blockEntity, ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        if (blockEntity instanceof IPaintable) {
            if (!level.func_201670_d()) {
                return ActionResultType.CONSUME;
            }
            IPaintColor color = ((IPaintable)blockEntity).getColor(dir);
            ColorUtils.setColor(itemStack, color);
            UpdateColorPickerPacket packet = new UpdateColorPickerPacket(context.func_221531_n(), itemStack);
            NetworkManager.sendToServer(packet);
            this.playSound(context);
            return ActionResultType.SUCCESS;
        }
        if (blockEntity instanceof IPaintProvider) {
            PlayerEntity player = context.func_195999_j();
            if (player != null && !player.func_225608_bj_()) {
                return ActionResultType.PASS;
            }
            IPaintProvider provider = (IPaintProvider)blockEntity;
            IPaintColor newColor = this.getItemColor(itemStack);
            if (newColor == null) {
                return ActionResultType.CONSUME;
            }
            if (!((Boolean)PaintingToolOptions.CHANGE_PAINT_TYPE.get(itemStack)).booleanValue()) {
                newColor = PaintColor.of(newColor.getRGB(), provider.getColor().getPaintType());
            }
            provider.setColor(newColor);
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    @Override
    public void createModelProperties(BiConsumer<ResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> ColorUtils.hasColor(itemStack) ? 0.0f : 1.0f);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.CHANGE_PAINT_TYPE);
    }

    @Override
    public void appendColorHoverText(ItemStack itemStack, List<ITextComponent> tooltips) {
        IPaintColor paintColor = this.getItemColor(itemStack);
        if (paintColor != null) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor, false));
        } else {
            tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.empty", new Object[0]));
        }
    }

    @Override
    public void setItemColor(ItemStack itemStack, IPaintColor paintColor) {
        ColorUtils.setColor(itemStack, paintColor);
    }

    @Override
    public IPaintColor getItemColor(ItemStack itemStack) {
        return ColorUtils.getColor(itemStack);
    }

    @Override
    public int getTintColor(ItemStack itemStack, int index) {
        if (index == 1) {
            return ColorUtils.getDisplayRGB(itemStack);
        }
        return -1;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        IPaintColor paintColor = this.getItemColor(itemStack, PaintColor.WHITE);
        return paintColor.getPaintType() != SkinPaintTypes.NORMAL;
    }

    @Override
    public IRegistryKey<SoundEvent> getItemSoundEvent(ItemUseContext context) {
        return ModSounds.PICKER;
    }
}

