/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.menu;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.api.math.ITexturePos;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartTypeTextured;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlot;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockContainerMenu;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class OutfitMakerMenu
extends AbstractBlockContainerMenu {
    private final IInventory inventory = this.getBlockInventory();

    public OutfitMakerMenu(ContainerType<?> menuType, Block block, int containerId, PlayerInventory playerInventory, IContainerLevelAccess access) {
        super(menuType, block, containerId, access);
        this.addPlayerSlots((IInventory)playerInventory, 8, 158);
        this.addInputSlots(this.inventory, 0, this.inventory.func_70302_i_() - 1, 36, 58);
        this.addOutputSlot(this.inventory, this.inventory.func_70302_i_() - 1, 148, 88);
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return this.quickMoveStack(player, index, this.field_75151_b.size() - 1);
    }

    public boolean shouldCrafting() {
        if (!this.getOutputStack().func_190926_b()) {
            return false;
        }
        for (ItemStack itemStack : this.getInputStacks()) {
            if (itemStack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void saveArmourItem(PlayerEntity player, GameProfile profile) {
        OutfitMakerBlockEntity blockEntity = this.getBlockEntity(OutfitMakerBlockEntity.class);
        if (!this.shouldCrafting() || blockEntity == null) {
            return;
        }
        ArrayList<SkinPart> skinParts = new ArrayList<SkinPart>();
        SkinProperties skinProperties = SkinProperties.create();
        String partIndexs = "";
        SkinPaintData paintData = null;
        int skinIndex = 0;
        for (ItemStack itemStack : this.getInputStacks()) {
            SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
            Skin skin = SkinLoader.getInstance().loadSkin(descriptor.getIdentifier());
            if (skin == null) continue;
            for (int partIndex = 0; partIndex < skin.getPartCount(); ++partIndex) {
                SkinPart skinPart = skin.getParts().get(partIndex);
                skinParts.add(skinPart);
            }
            if (skin.getPaintData() != null) {
                if (paintData == null) {
                    paintData = SkinPaintData.v2();
                }
                for (ISkinPartType iSkinPartType : skin.getType().getParts()) {
                    if (!(iSkinPartType instanceof ISkinPartTypeTextured)) continue;
                    ISkinPartTypeTextured texType = (ISkinPartTypeTextured)iSkinPartType;
                    this.mergePaintPart(texType, paintData, skin.getPaintData());
                }
            }
            partIndexs = partIndexs.isEmpty() ? String.valueOf(skinParts.size()) : partIndexs + ":" + skinParts.size();
            for (Map.Entry<String, Object> entry : skin.getProperties().entrySet()) {
                if (entry.getKey().startsWith("wings")) {
                    skinProperties.put(entry.getKey() + skinIndex, entry.getValue());
                    continue;
                }
                skinProperties.put(entry.getKey(), entry.getValue());
            }
            ++skinIndex;
        }
        if (paintData != null) {
            SkinPaintData resolvedPaintData = SkinPaintData.v1();
            resolvedPaintData.copyFrom(paintData);
            paintData = resolvedPaintData;
        }
        if (!skinParts.isEmpty()) {
            skinProperties.put(SkinProperty.OUTFIT_PART_INDEXS, partIndexs);
            skinProperties.put(SkinProperty.ALL_AUTHOR_NAME, profile.getName());
            if (profile.getId() != null) {
                skinProperties.put(SkinProperty.ALL_AUTHOR_UUID, profile.getId().toString());
            }
            skinProperties.put(SkinProperty.ALL_CUSTOM_NAME, blockEntity.getItemName());
            skinProperties.put(SkinProperty.ALL_FLAVOUR_TEXT, blockEntity.getItemFlavour());
            Skin.Builder builder = new Skin.Builder(SkinTypes.OUTFIT);
            builder.properties(skinProperties);
            builder.paintData(paintData);
            builder.parts(skinParts);
            Skin skin = builder.build();
            String identifier = SkinLoader.getInstance().saveSkin("", skin);
            SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.getType());
            this.setOutputStack(descriptor.asItemStack());
        }
    }

    protected void addInputSlots(IInventory inventory, int start, int end, int x, int y) {
        SkinSlotType[] skinTypes = new SkinSlotType[]{SkinSlotType.HEAD, SkinSlotType.CHEST, SkinSlotType.LEGS, SkinSlotType.FEET, SkinSlotType.WINGS};
        for (int i = start; i < end; ++i) {
            int col = i % 5;
            int row = i / 5;
            this.func_75146_a(new SkinSlot(inventory, i, x + col * 20, y + row * 20, skinTypes));
        }
    }

    protected void addOutputSlot(IInventory inventory, int slot, int x, int y) {
        this.func_75146_a(new Slot(inventory, slot, x, y){});
    }

    protected ItemStack getOutputStack() {
        Slot outputSlot = (Slot)this.field_75151_b.get(this.field_75151_b.size() - 1);
        return outputSlot.func_75211_c();
    }

    protected void setOutputStack(ItemStack itemStack) {
        Slot outputSlot = (Slot)this.field_75151_b.get(this.field_75151_b.size() - 1);
        outputSlot.func_75215_d(itemStack);
    }

    protected Iterable<ItemStack> getInputStacks() {
        return Iterables.transform((Iterable)Iterables.skip((Iterable)Iterables.limit((Iterable)this.field_75151_b, (int)(this.field_75151_b.size() - 1)), (int)36), Slot::func_75211_c);
    }

    private void mergePaintPart(ISkinPartTypeTextured texType, SkinPaintData desPaint, SkinPaintData srcPaint) {
        ITexturePos pos = texType.getTextureSkinPos();
        int width = texType.getTextureModelSize().getX() * 2 + texType.getTextureModelSize().getZ() * 2;
        int height = texType.getTextureModelSize().getY() + texType.getTextureModelSize().getZ();
        for (int ix = 0; ix < width; ++ix) {
            for (int iy = 0; iy < height; ++iy) {
                int y;
                int x = pos.getU() + ix;
                int color = srcPaint.getColor(x, y = pos.getV() + iy);
                if (!PaintColor.isOpaque(color)) continue;
                desPaint.setColor(x, y, color);
            }
        }
    }
}

