/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.api.action.IUndoAction;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.UndoStack;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import net.minecraft.command.CommandException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class UndoActionPacket
extends CustomPacket {
    private final boolean isRedo;

    public UndoActionPacket(PacketBuffer buffer) {
        this.isRedo = buffer.readBoolean();
    }

    public UndoActionPacket(boolean isRedo) {
        this.isRedo = isRedo;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.isRedo);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        try {
            IFormattableTextComponent message;
            UndoStack stack = UndoManager.of(player.func_110124_au());
            if (this.isRedo) {
                if (!ModPermissions.REDO.accept((PlayerEntity)player)) {
                    return;
                }
                IUndoAction command = stack.redo();
                message = TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.redoing", command.name());
            } else {
                if (!ModPermissions.UNDO.accept((PlayerEntity)player)) {
                    return;
                }
                IUndoAction command = stack.undo();
                message = TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.undoing", command.name());
            }
            SystemMessageProvider.sendSystemMessage((PlayerEntity)player, (ITextComponent)message);
        }
        catch (CommandException exception) {
            SystemMessageProvider.sendSystemMessage((PlayerEntity)player, exception.func_197003_a());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

