/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.other.CubeApplier;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.permission.BlockPermission;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class UpdateArmourerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Field field;
    private final Object fieldValue;

    public UpdateArmourerPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.field = (Field)buffer.func_179257_a(Field.class);
        this.fieldValue = this.field.getDataAccessor().dataSerializer.func_187159_a(buffer);
    }

    public UpdateArmourerPacket(ArmourerBlockEntity entity, Field field, Object value) {
        this.pos = entity.func_174877_v();
        this.field = field;
        this.fieldValue = value;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_179249_a((Enum)this.field);
        this.field.getDataAccessor().dataSerializer.func_187160_a(buffer, this.fieldValue);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        TileEntity blockEntity = player.func_71121_q().func_175625_s(this.pos);
        if (blockEntity instanceof ArmourerBlockEntity && player.field_71070_bA instanceof ArmourerMenu) {
            BlockUtils.beginCombiner();
            this.acceptFieldUpdate((PlayerEntity)player, (ArmourerBlockEntity)blockEntity, (ArmourerMenu)player.field_71070_bA);
            BlockUtils.endCombiner();
        }
    }

    private void acceptFieldUpdate(PlayerEntity player, ArmourerBlockEntity blockEntity, ArmourerMenu container) {
        String playerName = player.func_145748_c_().getString();
        if (!this.field.permission.accept(blockEntity, player)) {
            return;
        }
        switch (this.field) {
            case ITEM_LOAD: {
                container.loadArmourItem(player);
                break;
            }
            case ITEM_SAVE: {
                CompoundNBT nbt = (CompoundNBT)this.fieldValue;
                ModLog.info("accept save action of the {}, nbt: {}", playerName, nbt);
                GameProfile profile = DataSerializers.readGameProfile(nbt);
                container.saveArmourItem(player, profile, null, null);
                break;
            }
            case ITEM_CLEAR: {
                CompoundNBT nbt = (CompoundNBT)this.fieldValue;
                ModLog.info("accept clear action of the {}, nbt: {}", playerName, nbt);
                CubeApplier applier = new CubeApplier(blockEntity.func_145831_w());
                ISkinPartType partType = SkinPartTypes.byName(nbt.func_74779_i("PartType"));
                if (nbt.func_74767_n("Cubes")) {
                    blockEntity.clearCubes(applier, partType);
                }
                if (nbt.func_74767_n("Paints")) {
                    blockEntity.clearPaintData(applier, partType);
                }
                if (nbt.func_74767_n("Markers") && !nbt.func_74767_n("Cubes")) {
                    blockEntity.clearMarkers(applier, partType);
                }
                applier.submit((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "action.armourers_workshop.block.clear", new Object[0]), player);
                break;
            }
            case ITEM_COPY: {
                CompoundNBT nbt = (CompoundNBT)this.fieldValue;
                ModLog.info("accept copy action of the {}, nbt: {}", playerName, nbt);
                try {
                    boolean isMirror = nbt.func_74767_n("Mirror");
                    boolean isCopyPaintData = nbt.func_74767_n("Paints");
                    ISkinPartType sourcePartType = SkinPartTypes.byName(nbt.func_74779_i("Source"));
                    ISkinPartType destinationPartType = SkinPartTypes.byName(nbt.func_74779_i("Destination"));
                    CubeApplier applier = new CubeApplier(blockEntity.func_145831_w());
                    blockEntity.copyCubes(applier, sourcePartType, destinationPartType, isMirror);
                    if (isCopyPaintData) {
                        blockEntity.copyPaintData(applier, sourcePartType, destinationPartType, isMirror);
                    }
                    applier.submit((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "action.armourers_workshop.block.copy", new Object[0]), player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case ITEM_REPLACE: {
                CompoundNBT nbt = (CompoundNBT)this.fieldValue;
                ModLog.info("accept replace action of the {}, nbt: {}", playerName, nbt);
                try {
                    ItemStack source = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Source"));
                    ItemStack destination = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Destination"));
                    CubeReplacingEvent event = new CubeReplacingEvent(source, destination);
                    event.keepColor = nbt.func_74767_n("KeepColor");
                    event.keepPaintType = nbt.func_74767_n("KeepPaintType");
                    if (event.isEmptySource && event.isEmptyDestination) {
                        return;
                    }
                    CubeApplier applier = new CubeApplier(blockEntity.func_145831_w());
                    blockEntity.replaceCubes(applier, SkinPartTypes.UNKNOWN, event);
                    applier.submit((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "action.armourers_workshop.block.replace", new Object[0]), player);
                    SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.armourer.dialog.replace.success", applier.getChanges()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                this.field.set(blockEntity, this.fieldValue);
            }
        }
    }

    public static enum Field {
        FLAGS(DataSerializers.INT, ArmourerBlockEntity::getFlags, ArmourerBlockEntity::setFlags, ModPermissions.ARMOURER_SETTING),
        SKIN_TYPE(DataSerializers.SKIN_TYPE, ArmourerBlockEntity::getSkinType, ArmourerBlockEntity::setSkinType, ModPermissions.ARMOURER_SETTING),
        SKIN_PROPERTIES(DataSerializers.SKIN_PROPERTIES, ArmourerBlockEntity::getSkinProperties, ArmourerBlockEntity::setSkinProperties, ModPermissions.ARMOURER_SETTING),
        TEXTURE_DESCRIPTOR(DataSerializers.PLAYER_TEXTURE, ArmourerBlockEntity::getTextureDescriptor, ArmourerBlockEntity::setTextureDescriptor, ModPermissions.ARMOURER_SETTING),
        ITEM_CLEAR(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_CLEAR),
        ITEM_COPY(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_COPY),
        ITEM_REPLACE(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_REPLACE),
        ITEM_LOAD(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_LOAD),
        ITEM_SAVE(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_SAVE);

        public final BlockPermission permission;
        private final DataAccessor<ArmourerBlockEntity, ?> dataAccessor;

        private <T> Field(IEntitySerializer<T> dataSerializer, Function<ArmourerBlockEntity, T> supplier, BiConsumer<ArmourerBlockEntity, T> applier, BlockPermission permission) {
            this.permission = permission;
            this.dataAccessor = DataAccessor.of(dataSerializer, supplier, applier);
        }

        public <T> T get(ArmourerBlockEntity entity) {
            DataAccessor<ArmourerBlockEntity, T> dataAccessor = this.getDataAccessor();
            return dataAccessor.get(entity);
        }

        public <T> void set(ArmourerBlockEntity entity, T value) {
            DataAccessor<ArmourerBlockEntity, T> dataAccessor = this.getDataAccessor();
            dataAccessor.set(entity, value);
        }

        public <T> DataAccessor<ArmourerBlockEntity, T> getDataAccessor() {
            return (DataAccessor)ObjectUtils.unsafeCast(this.dataAccessor);
        }

        public BlockPermission getPermission() {
            return this.permission;
        }
    }
}

