/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.action.UndoNamedGroupAction;
import moe.plushie.armourers_workshop.builder.other.CubeChanges;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CubeApplier {
    private final World level;
    private final CubeWrapper wrapper;
    private final ArrayList<CubeChanges> changes = new ArrayList();

    public CubeApplier(World level) {
        this.level = level;
        this.wrapper = new CubeWrapper(level, this.changes::add);
    }

    public void submit(ITextComponent name, PlayerEntity player) {
        this.wrapper.setPos(null);
        if (this.changes.isEmpty()) {
            return;
        }
        UndoNamedGroupAction group = new UndoNamedGroupAction(name);
        this.changes.forEach(group::push);
        UndoManager.of(player.func_110124_au()).push(group.apply());
    }

    public World getLevel() {
        return this.level;
    }

    public int getChanges() {
        return this.changes.size();
    }

    public CubeWrapper wrap(BlockPos pos) {
        this.wrapper.setPos(pos);
        return this.wrapper;
    }
}

