/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.level.block.entity.BlockEntity.DataProvider;
import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.action.IUndoAction;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CubeChanges
implements IUndoAction,
IWorldUpdateTask {
    private final World level;
    private final BlockPos blockPos;
    private BlockState blockState;
    private CompoundNBT nbt;
    private Map<Direction, IPaintColor> colors;

    public CubeChanges(World level, BlockPos blockPos) {
        this.level = level;
        this.blockPos = blockPos;
    }

    public void setBlockState(BlockState blockState) {
        this.blockState = blockState;
    }

    public void setCompoundTag(CompoundNBT nbt) {
        this.nbt = nbt;
    }

    public void setColor(Direction dir, IPaintColor color) {
        if (this.colors == null) {
            this.colors = new HashMap<Direction, IPaintColor>();
        }
        this.colors.put(dir, color);
    }

    public void setColors(Map<Direction, IPaintColor> colors) {
        this.colors = colors;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    private boolean isChangeNBT() {
        return this.nbt != null || this.colors != null;
    }

    @Override
    public void prepare() throws CommandException {
        if (!this.isChangeNBT()) {
            return;
        }
        if (this.blockState != null) {
            return;
        }
        TileEntity blockEntity = this.level.func_175625_s(this.blockPos);
        if (blockEntity == null) {
            String value = String.format("x=%d, y=%d, z=%d", this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p());
            throw new CommandException((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.missingBlock", value));
        }
    }

    @Override
    public IUndoAction apply() throws CommandException {
        TileEntity blockEntity2;
        boolean isChangedNBT = false;
        CubeChanges changes = new CubeChanges(this.level, this.blockPos);
        if (this.blockState != null) {
            changes.setBlockState(this.level.func_180495_p(this.blockPos));
            isChangedNBT = true;
        }
        if (this.nbt != null) {
            isChangedNBT = true;
        }
        if (isChangedNBT) {
            ObjectUtils.ifPresent(this.level.func_175625_s(this.blockPos), blockEntity -> {
                CompoundNBT newTag = DataProvider.saveWithFullMetadata(blockEntity);
                changes.setCompoundTag(newTag);
            });
        } else if (this.colors != null && (blockEntity2 = this.level.func_175625_s(this.blockPos)) instanceof IPaintable) {
            IPaintable target = (IPaintable)blockEntity2;
            HashMap<Direction, IPaintColor> oldValue = new HashMap<Direction, IPaintColor>();
            for (Direction direction : this.colors.keySet()) {
                IPaintColor paintColor = target.getColor(direction);
                if (paintColor == null) {
                    paintColor = PaintColor.CLEAR;
                }
                oldValue.put(direction, paintColor);
            }
            changes.setColors(oldValue);
        }
        WorldUpdater.getInstance().submit(this);
        return changes;
    }

    @Override
    public World getLevel() {
        return this.level;
    }

    @Override
    public ActionResultType run(World level) {
        if (!level.func_195588_v(this.blockPos)) {
            return ActionResultType.PASS;
        }
        int changes = 0;
        if (this.blockState != null && !this.blockState.equals(level.func_180495_p(this.blockPos))) {
            level.func_180501_a(this.blockPos, this.blockState, 3);
            ++changes;
        }
        TileEntity blockEntity = null;
        if (this.isChangeNBT()) {
            blockEntity = level.func_175625_s(this.blockPos);
        }
        if (this.nbt != null && blockEntity != null) {
            DataProvider.load(blockEntity, this.nbt);
            ++changes;
        }
        if (this.colors != null && blockEntity instanceof IPaintable) {
            ((IPaintable)blockEntity).setColors(this.colors);
            ++changes;
        }
        if (changes == 0) {
            return ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }
}

