/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IItemColorProvider;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.builder.block.SkinCubeBlock;
import moe.plushie.armourers_workshop.builder.item.SkinCubeItem;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;

public class CubeReplacingEvent {
    public final ItemStack source;
    public final Block sourceBlock;
    public final BlockPaintColor sourceBlockColor;
    public final ItemStack destination;
    public final Block destinationBlock;
    public final BlockPaintColor destinationBlockColor;
    public final boolean isEmptySource;
    public final boolean isEmptyDestination;
    public final boolean isChangedBlock;
    public boolean keepColor = true;
    public boolean keepPaintType = true;
    public int changes = 0;
    public int blockChanges = 0;
    public int blockColorChanges = 0;

    public CubeReplacingEvent(ItemStack source, ItemStack destination) {
        this.source = source;
        this.sourceBlock = this.getBlock(source);
        this.sourceBlockColor = this.getBlockColor(source);
        this.destination = destination;
        this.destinationBlock = this.getBlock(destination);
        this.destinationBlockColor = this.getBlockColor(destination);
        this.isEmptySource = this.sourceBlock == null && this.sourceBlockColor == null;
        this.isEmptyDestination = this.destinationBlock == null && this.destinationBlockColor == null;
        this.isChangedBlock = this.isChangedBlock();
    }

    public boolean accept(CubeWrapper wrapper) {
        if (!wrapper.is(IPaintable.class)) {
            return false;
        }
        if (this.source.func_190926_b()) {
            return true;
        }
        if (this.sourceBlock != null && !wrapper.is(this.sourceBlock)) {
            return false;
        }
        if (this.sourceBlockColor != null) {
            int diff = 0;
            for (Direction dir : Direction.values()) {
                IPaintColor t;
                IPaintColor s = this.sourceBlockColor.getOrDefault(dir, PaintColor.WHITE);
                if (Objects.equals(s, t = wrapper.getColor(dir))) continue;
                ++diff;
            }
            if (this.isChangedBlock) {
                return diff < 1;
            }
            return diff < 6;
        }
        return true;
    }

    public void apply(CubeWrapper wrapper) {
        if (!wrapper.is(IPaintable.class)) {
            return;
        }
        int oldBlockChanges = this.blockChanges;
        int oldBlockColorChanges = this.blockColorChanges;
        if (!this.destination.func_190926_b() && this.destinationBlockColor != null) {
            this.applyColor(wrapper);
        }
        if (this.isChangedBlock) {
            this.applyBlock(wrapper);
        }
        if (oldBlockChanges != this.blockChanges || oldBlockColorChanges != this.blockColorChanges) {
            ++this.changes;
        }
    }

    private void applyColor(CubeWrapper wrapper) {
        if (this.keepColor && this.keepPaintType) {
            return;
        }
        HashMap<Direction, IPaintColor> newColors = new HashMap<Direction, IPaintColor>();
        for (Direction dir : Direction.values()) {
            IPaintColor sourceColor;
            IPaintColor targetColor = wrapper.getColor(dir);
            if (this.sourceBlockColor != null && !Objects.equals(sourceColor = this.sourceBlockColor.getOrDefault(dir, PaintColor.WHITE), targetColor)) {
                newColors.put(dir, targetColor);
                continue;
            }
            IPaintColor newColor = this.destinationBlockColor.getOrDefault(dir, PaintColor.WHITE);
            int color = newColor.getRGB();
            if (this.keepColor) {
                color = targetColor.getRGB();
            }
            ISkinPaintType paintType = newColor.getPaintType();
            if (this.keepPaintType) {
                paintType = targetColor.getPaintType();
            }
            newColor = PaintColor.of(color, paintType);
            newColors.put(dir, newColor);
        }
        wrapper.setColors(newColors);
        ++this.blockColorChanges;
    }

    private void applyBlock(CubeWrapper wrapper) {
        if (!wrapper.is(SkinCubeBlock.class)) {
            return;
        }
        CompoundNBT newNBT = null;
        BlockState oldState = wrapper.getBlockState();
        BlockState newState = Blocks.field_150350_a.func_176223_P();
        if (this.destinationBlock != null) {
            newNBT = wrapper.getBlockEntityNBT();
            newState = this.destinationBlock.func_176223_P();
            for (Property property : oldState.func_235904_r_()) {
                newState = this.applyBlockState(newState, oldState, property);
            }
        }
        wrapper.setBlockState(newState, newNBT);
        ++this.blockChanges;
    }

    private <T extends Comparable<T>> BlockState applyBlockState(BlockState newState, BlockState oldState, Property<T> property) {
        if (newState.func_235901_b_(property)) {
            return (BlockState)newState.func_206870_a(property, oldState.func_177229_b(property));
        }
        return newState;
    }

    private Block getBlock(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof SkinCubeItem) {
            return ((SkinCubeItem)item).func_179223_d();
        }
        return null;
    }

    private BlockPaintColor getBlockColor(ItemStack itemStack) {
        IPaintColor paintColor;
        Item item = itemStack.func_77973_b();
        if (item instanceof SkinCubeItem) {
            return ((SkinCubeItem)item).getItemColors(itemStack);
        }
        if (item instanceof IItemColorProvider && (paintColor = ((IItemColorProvider)item).getItemColor(itemStack)) != null) {
            return new BlockPaintColor(paintColor);
        }
        return null;
    }

    private boolean isChangedBlock() {
        if (this.source.func_190926_b() && this.destinationBlock != null) {
            return true;
        }
        if (this.destination.func_190926_b() && this.sourceBlock != null) {
            return true;
        }
        return this.destinationBlock != null && !this.destinationBlock.equals(this.sourceBlock);
    }
}

