/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import net.minecraft.block.BlockState;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class WorldUpdater {
    private static final WorldUpdater INSTANCE = new WorldUpdater();
    private final ArrayList<IWorldUpdateTask> failedTasks = new ArrayList();
    private final HashMap<RegistryKey<World>, AutoMergeQueue> allTasks = new HashMap();

    public static WorldUpdater getInstance() {
        return INSTANCE;
    }

    public synchronized void submit(IWorldUpdateTask task) {
        this.allTasks.computeIfAbsent((RegistryKey<World>)task.getLevel().func_234923_W_(), k -> new AutoMergeQueue()).push(task);
    }

    public void tick(World level) {
        IWorldUpdateTask task;
        RegistryKey key = level.func_234923_W_();
        if (this.isEmpty((RegistryKey<World>)key)) {
            return;
        }
        BlockUtils.beginCombiner();
        int count = ModConfig.Common.blockTaskRate;
        while (count > 0 && (task = this.poll((RegistryKey<World>)key)) != null) {
            ActionResultType resultType = task.run(level);
            if (resultType.func_226246_a_()) {
                --count;
                continue;
            }
            if (resultType != ActionResultType.FAIL) continue;
            this.failedTasks.add(task);
        }
        if (!this.failedTasks.isEmpty()) {
            this.failedTasks.forEach(this::submit);
            this.failedTasks.clear();
        }
        BlockUtils.endCombiner();
    }

    public synchronized void drain(World level) {
        AutoMergeQueue queue = this.allTasks.remove(level.func_234923_W_());
        if (queue == null || queue.isEmpty()) {
            return;
        }
        BlockUtils.beginCombiner();
        while (!queue.isEmpty()) {
            queue.pop().run(level);
        }
        BlockUtils.endCombiner();
    }

    public synchronized boolean isEmpty(RegistryKey<World> key) {
        AutoMergeQueue m = this.allTasks.get(key);
        return m == null || m.isEmpty();
    }

    @Nullable
    public synchronized IWorldUpdateTask poll(RegistryKey<World> key) {
        AutoMergeQueue m = this.allTasks.get(key);
        if (m != null && !m.isEmpty()) {
            return m.pop();
        }
        return null;
    }

    public static class AutoMergeQueue {
        private final HashMap<BlockPos, IWorldUpdateTask> fastTable = new HashMap();
        private final ArrayList<IWorldUpdateTask> tasks = new ArrayList();

        public void push(IWorldUpdateTask task) {
            BlockPos blockPos = task.getBlockPos();
            IWorldUpdateTask pendingTask = this.fastTable.get(blockPos);
            if (pendingTask == null) {
                this.tasks.add(task);
                this.fastTable.put(blockPos, task);
                return;
            }
            if (pendingTask instanceof AutoMergeTask) {
                ((AutoMergeTask)pendingTask).add(task);
                return;
            }
            AutoMergeTask mergedTask = new AutoMergeTask(pendingTask);
            mergedTask.add(task);
            this.fastTable.put(blockPos, mergedTask);
        }

        public IWorldUpdateTask pop() {
            IWorldUpdateTask task = this.tasks.remove(0);
            IWorldUpdateTask mergedTask = this.fastTable.remove(task.getBlockPos());
            if (mergedTask != null) {
                return mergedTask;
            }
            return task;
        }

        public boolean isEmpty() {
            return this.tasks.isEmpty();
        }
    }

    public static class AutoMergeTask
    implements IWorldUpdateTask {
        private final World level;
        private final BlockPos blockPos;
        private final ArrayList<IWorldUpdateTask> tasks = new ArrayList();

        public AutoMergeTask(IWorldUpdateTask task) {
            this.level = task.getLevel();
            this.blockPos = task.getBlockPos();
            this.tasks.add(task);
        }

        public void add(IWorldUpdateTask task) {
            this.tasks.add(task);
        }

        public void optimize(World level) {
            ArrayList<IWorldUpdateTask> optimizedTasks = new ArrayList<IWorldUpdateTask>();
            BlockState lastBlockState = null;
            for (IWorldUpdateTask task : this.tasks) {
                BlockState newBlockState = task.getBlockState();
                if (!Objects.equals(newBlockState, lastBlockState)) {
                    lastBlockState = newBlockState;
                    optimizedTasks.clear();
                }
                optimizedTasks.add(task);
            }
            if (this.tasks.size() != optimizedTasks.size()) {
                this.tasks.clear();
                this.tasks.addAll(optimizedTasks);
            }
        }

        @Override
        public World getLevel() {
            return this.level;
        }

        @Override
        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        @Override
        public BlockState getBlockState() {
            return null;
        }

        @Override
        public ActionResultType run(World level) {
            this.optimize(level);
            int changes = 0;
            ArrayList<IWorldUpdateTask> failedTasks = new ArrayList<IWorldUpdateTask>();
            for (IWorldUpdateTask task : this.tasks) {
                ActionResultType resultType = task.run(level);
                if (resultType.func_226246_a_()) {
                    ++changes;
                }
                if (resultType != ActionResultType.FAIL) continue;
                failedTasks.add(task);
            }
            if (!failedTasks.isEmpty()) {
                this.tasks.clear();
                this.tasks.addAll(failedTasks);
                return ActionResultType.FAIL;
            }
            if (changes != 0) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
    }
}

