/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import extensions.net.minecraft.client.renderer.RenderType.ColorLogicProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderFormat;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class AbstractRenderType
extends RenderType {
    private static final VertexFormat SKIN_NORMAL_FORMAT = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181714_n).add((Object)DefaultVertexFormats.field_181715_o).add((Object)DefaultVertexFormats.field_181716_p).add((Object)DefaultVertexFormats.field_181717_q).add((Object)DefaultVertexFormats.field_181718_r).build());
    private static final RenderState.TexturingState COLORS_OFFSET = new RenderState.TexturingState("aw_offset_ov", () -> {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)ABI.convertMatrix(MatrixStack.class, RenderSystem.getExtendedTextureMatrix()));
        RenderSystem.matrixMode((int)5888);
    }, () -> {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    });
    private static final RenderState.TexturingState OR_REVERSE = new RenderState.TexturingState("aw_or_reverse", () -> {
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
    }, () -> {
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    });
    private static final RenderState.TextureState EMPTY_TEXTURE = new RenderState.TextureState(){

        public void func_228547_a_() {
        }

        public void func_228549_b_() {
        }
    };
    private static final RenderState.TransparencyState DEFAULT_TRANSPARENCY = new RenderState.TransparencyState("aw_defaul_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, () -> RenderSystem.disableBlend());
    private static final Map<SkinRenderFormat, Supplier<IRenderTypeBuilder>> MAPPER = AbstractRenderType._make(it -> {
        it.put(SkinRenderFormat.LINE, () -> AbstractRenderType._builder(DefaultVertexFormats.field_181706_f, 1, builder -> builder.func_228713_a_(field_228517_i_)));
        it.put(SkinRenderFormat.IMAGE, () -> AbstractRenderType._builder(DefaultVertexFormats.field_227852_q_, 7, builder -> builder.func_228713_a_(field_228517_i_)));
        it.put(SkinRenderFormat.GUI_IMAGE, () -> AbstractRenderType._builder(DefaultVertexFormats.field_181707_g, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228724_a_(EMPTY_TEXTURE)));
        it.put(SkinRenderFormat.GUI_HIGHLIGHTED_TEXT, () -> AbstractRenderType._builder(DefaultVertexFormats.field_181705_e, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228725_a_(OR_REVERSE)));
        it.put(SkinRenderFormat.GUI_COLOR, () -> AbstractRenderType._builder(DefaultVertexFormats.field_181706_f, 7, builder -> builder.func_228726_a_(DEFAULT_TRANSPARENCY)));
        it.put(SkinRenderFormat.BLOCK, () -> AbstractRenderType._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinRenderFormat.BLOCK_CUTOUT, () -> AbstractRenderType._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinRenderFormat.ENTITY_CUTOUT, () -> AbstractRenderType._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinRenderFormat.ENTITY_CUTOUT_NO_CULL, () -> AbstractRenderType._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinRenderFormat.ENTITY_TRANSLUCENT, () -> AbstractRenderType._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinRenderFormat.ENTITY_ALPHA, () -> AbstractRenderType._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_)));
        it.put(SkinRenderFormat.SKIN_FACE_SOLID, () -> AbstractRenderType._builder(SKIN_NORMAL_FORMAT, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_)));
        it.put(SkinRenderFormat.SKIN_FACE_TRANSLUCENT, () -> AbstractRenderType._builder(SKIN_NORMAL_FORMAT, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_).func_228713_a_(field_228517_i_)));
        it.put(SkinRenderFormat.SKIN_FACE_LIGHTING, () -> AbstractRenderType._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET)));
        it.put(SkinRenderFormat.SKIN_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderType._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_)));
    });

    public AbstractRenderType(String name, RenderType delegate, boolean affectsCrumbling, boolean sortUpload, Runnable setupRenderState, Runnable clearRenderState) {
        super(name, delegate.func_228663_p_(), delegate.func_228664_q_(), delegate.func_228662_o_(), affectsCrumbling, sortUpload, () -> {
            delegate.func_228547_a_();
            setupRenderState.run();
        }, () -> {
            clearRenderState.run();
            delegate.func_228549_b_();
        });
    }

    private static Builder _builder(VertexFormat format, int mode, Function<RenderType.State.Builder, RenderType.State.Builder> config) {
        Builder builder = new Builder(format, mode);
        builder.stateBuilder = config.apply(builder.stateBuilder);
        return builder;
    }

    public static IRenderTypeBuilder builder(SkinRenderFormat format) {
        Supplier<IRenderTypeBuilder> provider = MAPPER.get((Object)format);
        if (provider != null) {
            return provider.get();
        }
        throw new RuntimeException("can't supported render format");
    }

    private static <T, U> HashMap<T, U> _make(Consumer<HashMap<T, U>> consumer) {
        HashMap map = new HashMap();
        consumer.accept(map);
        return map;
    }

    public static class Builder
    implements IRenderTypeBuilder {
        private static final Map<IRenderTypeBuilder.Target, RenderState.TargetState> TABLE_OUTPUT = Builder._make(it -> {
            it.put(IRenderTypeBuilder.Target.TRANSLUCENT, field_239236_S_);
            it.put(IRenderTypeBuilder.Target.MAIN, field_228504_N_);
        });
        private static final Map<IRenderTypeBuilder.Transparency, RenderState.TransparencyState> TABLE_TRANSPARENCY = Builder._make(it -> {
            it.put(IRenderTypeBuilder.Transparency.DEFAULT, DEFAULT_TRANSPARENCY);
            it.put(IRenderTypeBuilder.Transparency.TRANSLUCENT, field_228515_g_);
            it.put(IRenderTypeBuilder.Transparency.NONE, field_228510_b_);
        });
        private static final Map<IRenderTypeBuilder.WriteMask, RenderState.WriteMaskState> TABLE_WRITE_MASK = Builder._make(it -> {
            it.put(IRenderTypeBuilder.WriteMask.COLOR_DEPTH_WRITE, field_228495_E_);
            it.put(IRenderTypeBuilder.WriteMask.COLOR_WRITE, field_228496_F_);
            it.put(IRenderTypeBuilder.WriteMask.DEPTH_WRITE, field_228497_G_);
        });
        private static final Map<IRenderTypeBuilder.DepthTest, RenderState.DepthTestState> TABLE_DEPTH_TEST = Builder._make(it -> {
            it.put(IRenderTypeBuilder.DepthTest.NONE, field_228492_B_);
            it.put(IRenderTypeBuilder.DepthTest.EQUAL, field_228493_C_);
            it.put(IRenderTypeBuilder.DepthTest.LESS_EQUAL, field_228494_D_);
        });
        boolean isOutline = false;
        boolean affectsCrumbling = false;
        boolean sortOnUpload = false;
        RenderType renderType;
        RenderType.State.Builder stateBuilder = RenderType.State.func_228694_a_();
        int mode;
        VertexFormat format;

        private static <T, U> HashMap<T, U> _make(Consumer<HashMap<T, U>> consumer) {
            HashMap map = new HashMap();
            consumer.accept(map);
            return map;
        }

        private Builder(VertexFormat format, int mode) {
            this.format = format;
            this.mode = mode;
            this.setupDefault();
        }

        private void setupDefault() {
            if (this.renderType != null) {
                this.affectsCrumbling = this.renderType.func_228665_s_();
            }
            this.stateBuilder.func_228714_a_(field_228491_A_);
        }

        @Override
        public IRenderTypeBuilder texture(ResourceLocation texture, boolean blur, boolean mipmap) {
            RenderState.TextureState state = new RenderState.TextureState(texture, blur, mipmap);
            this.stateBuilder = this.stateBuilder.func_228724_a_(state);
            return this;
        }

        @Override
        public IRenderTypeBuilder texturing(IRenderTypeBuilder.Texturing texturing) {
            return this;
        }

        @Override
        public IRenderTypeBuilder target(IRenderTypeBuilder.Target target) {
            this.stateBuilder = this.stateBuilder.func_228721_a_(TABLE_OUTPUT.getOrDefault((Object)target, field_228504_N_));
            return this;
        }

        @Override
        public IRenderTypeBuilder transparency(IRenderTypeBuilder.Transparency transparency) {
            this.stateBuilder = this.stateBuilder.func_228726_a_(TABLE_TRANSPARENCY.getOrDefault((Object)transparency, field_228510_b_));
            return this;
        }

        @Override
        public IRenderTypeBuilder writeMask(IRenderTypeBuilder.WriteMask mask) {
            this.stateBuilder = this.stateBuilder.func_228727_a_(TABLE_WRITE_MASK.getOrDefault((Object)mask, field_228495_E_));
            return this;
        }

        @Override
        public IRenderTypeBuilder depthTest(IRenderTypeBuilder.DepthTest test) {
            this.stateBuilder = this.stateBuilder.func_228715_a_(TABLE_DEPTH_TEST.getOrDefault((Object)test, field_228492_B_));
            return this;
        }

        @Override
        public IRenderTypeBuilder colorLogic(IRenderTypeBuilder.ColorLogic state) {
            this.stateBuilder = ColorLogicProvider.CompositeState.CompositeStateBuilder.setColorLogicState(this.stateBuilder, state);
            return this;
        }

        @Override
        public IRenderTypeBuilder polygonOffset(float factor, float units) {
            this.stateBuilder = this.stateBuilder.func_228718_a_(new RenderState.LayerState("aw_polygon_offset_" + units, () -> {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)factor, (float)units);
            }, () -> {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }));
            return this;
        }

        @Override
        public IRenderTypeBuilder stroke(float width) {
            this.stateBuilder = this.stateBuilder.func_228718_a_(new RenderState.LayerState("aw_custom_line", () -> {
                GL11.glPolygonMode((int)1032, (int)6913);
                GL11.glLineWidth((float)width);
            }, () -> GL11.glPolygonMode((int)1032, (int)6914)));
            return this;
        }

        @Override
        public IRenderTypeBuilder lineWidth(float width) {
            this.stateBuilder = this.stateBuilder.func_228720_a_(new RenderState.LineState(OptionalDouble.of(width)));
            return this;
        }

        @Override
        public IRenderTypeBuilder cull() {
            this.stateBuilder = this.stateBuilder.func_228714_a_(field_228534_z_);
            return this;
        }

        @Override
        public IRenderTypeBuilder lightmap() {
            this.stateBuilder = this.stateBuilder.func_228719_a_(field_228528_t_);
            return this;
        }

        @Override
        public IRenderTypeBuilder overlay() {
            this.stateBuilder = this.stateBuilder.func_228722_a_(field_228530_v_);
            return this;
        }

        @Override
        public IRenderTypeBuilder outline() {
            this.isOutline = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder crumbling() {
            this.affectsCrumbling = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder sortOnUpload() {
            this.sortOnUpload = true;
            return this;
        }

        @Override
        public RenderType build(String name) {
            return RenderType.func_228633_a_((String)name, (VertexFormat)this.format, (int)this.mode, (int)256, (boolean)this.affectsCrumbling, (boolean)this.sortOnUpload, (RenderType.State)this.stateBuilder.func_228728_a_(this.isOutline));
        }
    }
}

