/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGGraphicsRenderer;
import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIFont;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreenImpl;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class AbstractGraphicsRenderer
implements CGGraphicsRenderer,
CGGraphicsState {
    private static final IRenderTypeBuffer.Impl SHARED_BUFFERS = IRenderTypeBuffer.func_228455_a_((BufferBuilder)new BufferBuilder(256));
    private final MatrixStack poseStack;
    private final CGPoint mousePos;
    private final float partialTicks;
    private final AbstractMenuScreenImpl<?> screen;
    private final FontRenderer font;
    private UIFont uifont;

    public AbstractGraphicsRenderer(AbstractMenuScreenImpl<?> screen, FontRenderer font, MatrixStack poseStack, float mouseX, float mouseY, float partialTicks) {
        this.screen = screen;
        this.font = font;
        this.poseStack = poseStack;
        this.mousePos = new CGPoint(mouseX, mouseY);
        this.partialTicks = partialTicks;
    }

    public static MatrixStack of(CGGraphicsContext context) {
        AbstractGraphicsRenderer impl = (AbstractGraphicsRenderer)ObjectUtils.unsafeCast(context.state());
        return impl.poseStack;
    }

    public static CGGraphicsContext of(AbstractMenuScreenImpl<?> screen, FontRenderer font, MatrixStack poseStack, float mouseX, float mouseY, float partialTicks) {
        AbstractGraphicsRenderer impl = new AbstractGraphicsRenderer(screen, font, poseStack, mouseX, mouseY, partialTicks);
        return new CGGraphicsContext(impl, impl);
    }

    @Override
    public void renderTooltip(NSString text, CGRect rect, @Nullable UIFont font, CGGraphicsContext context) {
        if (font == null) {
            font = context.state().font();
        }
        List texts = font.impl().func_238425_b_((ITextProperties)text.component(), 100000);
        this.screen._renderTooltip(this.poseStack, texts, (int)this.mousePos.getX(), (int)this.mousePos.getY());
    }

    @Override
    public void renderEntity(LivingEntity entity, int x, int y, int scale, float mouseX, float mouseY, CGGraphicsContext context) {
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)this.poseStack.func_227866_c_().func_227870_a_());
        InventoryScreen.func_228187_a_((int)x, (int)y, (int)scale, (float)mouseX, (float)mouseY, (LivingEntity)entity);
        RenderSystem.popMatrix();
    }

    @Override
    public void renderItem(ItemStack itemStack, int x, int y, CGGraphicsContext context) {
        Minecraft.func_71410_x().func_175599_af().func_239390_c_(itemStack, x, y);
    }

    @Override
    public void flush() {
        SHARED_BUFFERS.func_228461_a_();
    }

    @Override
    public UIFont font() {
        if (this.uifont == null) {
            this.uifont = new UIFont(this.font, 9.0f);
        }
        return this.uifont;
    }

    @Override
    public CGPoint mousePos() {
        return this.mousePos;
    }

    @Override
    public float partialTicks() {
        return this.partialTicks;
    }

    @Override
    public IRenderTypeBuffer buffers() {
        return SHARED_BUFFERS;
    }

    @Override
    public MatrixStack ctm() {
        return this.poseStack;
    }
}

