/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.util.function.Supplier;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.minecraft.entity.Entity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractForgeNetworkManager
extends NetworkEvent {
    public AbstractForgeNetworkManager() {
        super(() -> null);
    }

    public static void register(ResourceLocation channelName, String channelVersion, Object dispatcher) {
        EventNetworkChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).networkProtocolVersion(() -> channelVersion).clientAcceptedVersions(sv -> true).serverAcceptedVersions(cv -> {
            if (ModConfig.Common.enableProtocolCheck) {
                return cv.equals(channelVersion);
            }
            return true;
        }).eventNetworkChannel();
        channel.registerObject(dispatcher);
    }

    public static PacketDistributor.PacketTarget allPlayers() {
        return PacketDistributor.ALL.noArg();
    }

    public static PacketDistributor.PacketTarget trackingEntityAndSelf(Supplier<Entity> supplier) {
        return PacketDistributor.TRACKING_ENTITY_AND_SELF.with(supplier);
    }

    public static enum Direction {
        PLAY_TO_SERVER(NetworkDirection.PLAY_TO_SERVER),
        PLAY_TO_CLIENT(NetworkDirection.PLAY_TO_CLIENT);

        private final NetworkDirection networkDirection;

        private Direction(NetworkDirection networkDirection) {
            this.networkDirection = networkDirection;
        }

        public <T extends IPacket<?>> ICustomPacket<T> buildPacket(Pair<PacketBuffer, Integer> packetData, ResourceLocation channelName) {
            return this.networkDirection.buildPacket(packetData, channelName);
        }
    }
}

