/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.init.client.EpicFlightWardrobeHandler;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.FirstPersonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Pseudo
@Mixin(value={PatchedLivingEntityRenderer.class})
public abstract class ForgeEpicFightRendererMixin {
    private static final FloatBuffer AW_MAT_BUFFER3 = ObjectUtils.createFloatBuffer(16);
    private static final FloatBuffer AW_MAT_BUFFER4 = ObjectUtils.createFloatBuffer(16);

    @Inject(method={"renderLayer"}, at={@At(value="HEAD")}, remap=false)
    public void aw$renderLayerPre(LivingRenderer<?, ?> renderer, LivingEntityPatch<?> entityPatch, LivingEntity entityIn, OpenMatrix4f[] poses, IRenderTypeBuffer buffers, MatrixStack poseStack, int packedLightIn, float partialTicks, CallbackInfo callbackInfo) {
        Armature armature = ((ClientModel)entityPatch.getEntityModel((Models)ClientModels.LOGICAL_CLIENT)).getArmature();
        boolean isFirstPersonRenderer = ObjectUtils.safeCast(this, FirstPersonRenderer.class) != null;
        EpicFlightWardrobeHandler.onRenderLivingPre(entityIn, partialTicks, packedLightIn, poseStack, buffers, renderer, isFirstPersonRenderer, name -> {
            Joint joint = armature.searchJointByName(name);
            if (joint == null) {
                return ITransformf.NONE;
            }
            return poseStack1 -> {
                OpenMatrix4f jointMatrix = poses[joint.getId()];
                OpenMatrix4f jointNormalMatrix = jointMatrix.removeTranslation();
                jointMatrix.store(AW_MAT_BUFFER4);
                jointNormalMatrix.store(AW_MAT_BUFFER3);
                AW_MAT_BUFFER3.position(0);
                AW_MAT_BUFFER4.position(0);
                EpicFlightWardrobeHandler.applyPoseFromBuffer(poseStack1, AW_MAT_BUFFER4, AW_MAT_BUFFER3);
            };
        });
    }

    @Inject(method={"renderLayer"}, at={@At(value="RETURN")}, remap=false)
    public void aw$renderLayerPost(LivingRenderer<?, ?> renderer, LivingEntityPatch<?> entityPatch, LivingEntity entityIn, OpenMatrix4f[] poses, IRenderTypeBuffer buffers, MatrixStack poseStack, int packedLightIn, float partialTicks, CallbackInfo callbackInfo) {
        EpicFlightWardrobeHandler.onRenderLivingPost(entityIn, partialTicks, packedLightIn, poseStack, buffers, renderer);
    }

    @Inject(method={"getRenderType"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    public void aw$getRenderType(LivingEntity entityIn, LivingEntityPatch<?> entityPatch, LivingRenderer<?, ?> renderer, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing, CallbackInfoReturnable<RenderType> callbackInfo) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entityIn);
        if (renderData != null && renderData.getOverriddenManager().overrideAnyModel()) {
            callbackInfo.setReturnValue(null);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    public void aw$init(CallbackInfo callbackInfo) {
        EpicFlightWardrobeHandler.onSetup();
    }
}

