/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.face.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.face.SkinCuller;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.transform.SkinTransform;
import moe.plushie.armourers_workshop.utils.math.OpenRay;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import moe.plushie.armourers_workshop.utils.texture.PlayerTextureModel;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import moe.plushie.armourers_workshop.utils.texture.SkyBox;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class PackedQuad {
    private final HashMap<Direction, ArrayList<SkinCubeFace>> dirFaces = new HashMap();
    private final HashMap<RenderType, ArrayList<SkinCubeFace>> splitFaces = new HashMap();
    private final Rectangle3i bounds;
    private final SkinTransform transform;
    private final OpenVoxelShape renderShape;
    private final ColorDescriptor colorInfo = new ColorDescriptor();
    private int faceTotal = 0;

    public PackedQuad(Rectangle3i bounds, SkinTransform transform, OpenVoxelShape renderShape, ArrayList<SkinCubeFace> faces) {
        this.bounds = bounds;
        this.transform = transform;
        this.renderShape = renderShape;
        this.loadFaces(faces);
    }

    public static PackedQuads from(SkinPart part) {
        PackedQuads quads = new PackedQuads();
        SkinCubes data = part.getCubeData();
        OpenVoxelShape renderShape = data.getRenderShape();
        Rectangle3i bounds = new Rectangle3i(renderShape.bounds());
        SkinCuller.cullFaces2(data, bounds, part.getType()).forEach((? super T result) -> {
            Rectangle3i newBounds = bounds;
            SkinTransform newTransform = SkinTransform.createTranslateTransform(new Vector3f(result.getOrigin()));
            OpenVoxelShape newRenderShape = renderShape;
            if (result.getPartType() != part.getType()) {
                newBounds = result.getBounds().offset(bounds.getOrigin());
                newRenderShape = OpenVoxelShape.box(new Rectangle3f(newBounds));
            }
            quads.add(result.getPartType(), new PackedQuad(newBounds, newTransform, newRenderShape, result.getFaces()));
        });
        return quads;
    }

    public static PackedQuads from(SkinPaintData paintData) {
        PackedQuads allQuads = new PackedQuads();
        if (paintData == null) {
            return allQuads;
        }
        for (Map.Entry entry : PlayerTextureModel.of(paintData.getWidth(), paintData.getHeight(), false).entrySet()) {
            SkyBox box = (SkyBox)entry.getValue();
            ArrayList<SkinCubeFace> quads = new ArrayList<SkinCubeFace>();
            box.forEach((TexturePos texture, int x, int y, int z, Direction dir) -> {
                PaintColor paintColor = PaintColor.of(paintData.getColor(texture));
                if (paintColor.getPaintType() == SkinPaintTypes.NONE) {
                    return;
                }
                Vector3i pos = new Vector3i(x, y, z);
                quads.add(new SkinCubeFace(pos, paintColor, 255, dir, SkinCubeTypes.SOLID));
            });
            if (quads.size() == 0) continue;
            Rectangle3i bounds = box.getBounds();
            OpenVoxelShape renderShape = OpenVoxelShape.box(new Rectangle3f(bounds));
            allQuads.add((ISkinPartType)entry.getKey(), new PackedQuad(bounds, SkinTransform.IDENTIFIER, renderShape, quads));
        }
        return allQuads;
    }

    public void forEach(BiConsumer<RenderType, ArrayList<SkinCubeFace>> action) {
        this.splitFaces.forEach(action);
    }

    public void forEach(OpenRay ray, Consumer<SkinCubeFace> recorder) {
        if (this.dirFaces.isEmpty()) {
            this.loadDirFaces();
        }
        this.dirFaces.forEach((? super K dir, ? super V faces) -> {
            for (SkinCubeFace face : faces) {
                if (!face.intersects(ray)) continue;
                recorder.accept(face);
            }
        });
    }

    private void loadFaces(ArrayList<SkinCubeFace> faces) {
        for (SkinCubeFace skinCubeFace : faces) {
            if (skinCubeFace.getPaintType() == SkinPaintTypes.NONE) continue;
            RenderType renderType = SkinRenderType.by(skinCubeFace.getType());
            this.splitFaces.computeIfAbsent(renderType, k -> new ArrayList()).add(skinCubeFace);
            this.colorInfo.add(skinCubeFace.getColor());
            ++this.faceTotal;
        }
        for (ArrayList arrayList : this.splitFaces.values()) {
            arrayList.sort(Comparator.comparingInt(f -> f.getDirection().func_176745_a()));
        }
    }

    private void loadDirFaces() {
        this.splitFaces.values().forEach((? super T faces) -> faces.forEach((? super E face) -> this.dirFaces.computeIfAbsent(face.getDirection(), k -> new ArrayList()).add(face)));
    }

    public ColorDescriptor getColorInfo() {
        return this.colorInfo;
    }

    public Rectangle3i getBounds() {
        return this.bounds;
    }

    public SkinTransform getTransform() {
        return this.transform;
    }

    public OpenVoxelShape getRenderShape() {
        return this.renderShape;
    }

    public int getFaceTotal() {
        return this.faceTotal;
    }

    public static class PackedQuads {
        ArrayList<Pair<ISkinPartType, PackedQuad>> quads = new ArrayList();

        public void add(ISkinPartType partType, PackedQuad quad) {
            this.quads.add((Pair<ISkinPartType, PackedQuad>)Pair.of((Object)partType, (Object)quad));
        }

        public void forEach(BiConsumer<ISkinPartType, PackedQuad> consumer) {
            this.quads.forEach((Consumer<Pair<ISkinPartType, PackedQuad>>)((Consumer<Pair>)pair -> consumer.accept((ISkinPartType)pair.getKey(), (PackedQuad)pair.getValue())));
        }
    }
}

