/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import extensions.net.minecraft.world.entity.player.Player.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinPreloadManager {
    private static Object lastInventoryVersion = null;

    public static void start() {
        lastInventoryVersion = null;
    }

    public static void stop() {
    }

    public static void tick(boolean isPaused) {
        ClientPlayerEntity player;
        if (isPaused) {
            return;
        }
        if (lastInventoryVersion == null && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            PlayerInventory inventory = PropertyProvider.getInventory((PlayerEntity)player);
            int inventoryVersion = inventory.func_194015_p();
            SkinPreloadManager.preloadInventory(inventory);
            lastInventoryVersion = inventoryVersion;
        }
        SkinPreloadManager.preloadConfig();
    }

    private static void preloadConfig() {
    }

    private static void preloadInventory(PlayerInventory inventory) {
        int size = inventory.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            SkinDescriptor descriptor = SkinDescriptor.of(inventory.func_70301_a(i));
            if (descriptor.isEmpty()) continue;
            ModLog.debug("'{}' => start preload skin", descriptor.getIdentifier());
            SkinBakery.getInstance().loadSkin(descriptor, Tickets.PRELOAD);
        }
    }
}

