/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.hologramprojector;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorBaseSetting;
import moe.plushie.armourers_workshop.core.network.UpdateHologramProjectorPacket;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HologramProjectorExtraSetting
extends HologramProjectorBaseSetting {
    private final HologramProjectorBlockEntity entity;
    private final UpdateHologramProjectorPacket.Field field = UpdateHologramProjectorPacket.Field.POWER_MODE;
    private final UpdateHologramProjectorPacket.Field field2 = UpdateHologramProjectorPacket.Field.IS_GLOWING;

    public HologramProjectorExtraSetting(HologramProjectorBlockEntity entity) {
        super("inventory.armourers_workshop.hologram-projector.extra");
        this.entity = entity;
        this.setFrame(new CGRect(0.0f, 0.0f, 200.0f, 78.0f));
        this.setup();
    }

    private void setup() {
        this.setupOption(11, 30, this.field2, "glowing");
        this.setupComboList(11, 55, this.field);
        UILabel label = new UILabel(new CGRect(11.0f, 45.0f, 178.0f, 9.0f));
        label.setText(this.getDisplayText("powerMode"));
        this.addSubview(label);
    }

    private void setupOption(int x, int y, UpdateHologramProjectorPacket.Field field, String key) {
        UICheckBox checkBox = new UICheckBox(new CGRect(x, y, 178.0f, 10.0f));
        checkBox.setTitle(this.getDisplayText(key));
        checkBox.setSelected((Boolean)field.get(this.entity));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            UICheckBox checkBox1 = (UICheckBox)ObjectUtils.unsafeCast(c);
            field.set(this.entity, checkBox1.isSelected());
            UpdateHologramProjectorPacket packet = new UpdateHologramProjectorPacket(this.entity, field, checkBox1.isSelected());
            NetworkManager.sendToServer(packet);
        });
        this.addSubview(checkBox);
    }

    private void setupComboList(int x, int y, UpdateHologramProjectorPacket.Field field) {
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        items.add(new UIComboItem(this.getDisplayText("powerMode.ignored")));
        items.add(new UIComboItem(this.getDisplayText("powerMode.high")));
        items.add(new UIComboItem(this.getDisplayText("powerMode.low")));
        UIComboBox comboBox = new UIComboBox(new CGRect(x, y, 80.0f, 14.0f));
        comboBox.setSelectedIndex((Integer)field.get(this.entity));
        comboBox.reloadData(items);
        comboBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, e) -> {
            UIComboBox comboBox1 = (UIComboBox)ObjectUtils.unsafeCast(e);
            field.set(this.entity, comboBox1.selectedIndex());
            UpdateHologramProjectorPacket packet = new UpdateHologramProjectorPacket(this.entity, field, comboBox1.selectedIndex());
            NetworkManager.sendToServer(packet);
        });
        this.addSubview(comboBox);
    }
}

