/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.wardrobe;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.KeyboardManagerImpl;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UISliderBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IResourceManager;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeBaseSetting;
import moe.plushie.armourers_workshop.core.client.gui.widget.EntityPartView;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.ClientNativeManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.Rotations;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeRotationSetting
extends SkinWardrobeBaseSetting {
    private final SkinWardrobe wardrobe;
    private final Entity entity;
    private final EntityPartView partView = new EntityPartView(new CGRect(83.0f, 25.0f, 24.0f, 40.0f));
    private UISliderBox sliderX;
    private UISliderBox sliderY;
    private UISliderBox sliderZ;
    private static int RANDOMLY_INDEX = 0;
    private static ArrayList<HashMap<EntityPartView.Part, Rotations>> RANDOMLY_ROTATIONS;

    public SkinWardrobeRotationSetting(SkinWardrobe wardrobe, Entity entity) {
        super("inventory.armourers_workshop.wardrobe.man_rotations");
        this.wardrobe = wardrobe;
        this.entity = entity;
        this.setup();
        if (RANDOMLY_ROTATIONS == null) {
            RANDOMLY_ROTATIONS = new ArrayList();
            this.loadRandomlyRotations();
        }
    }

    private void setup() {
        this.partView.addTarget(this, UIControl.Event.VALUE_CHANGED, SkinWardrobeRotationSetting::updateSelectedPart);
        this.addSubview(this.partView);
        this.sliderX = this.setupSlider(110, 25, "X: ");
        this.sliderY = this.setupSlider(110, 36, "Y: ");
        this.sliderZ = this.setupSlider(110, 47, "Z: ");
        this.setupButton(83, 70, "reset", SkinWardrobeRotationSetting::resetRotation);
        this.setupButton(83, 90, "random", SkinWardrobeRotationSetting::randomRotation);
        this.setSelectedPart(EntityPartView.Part.BODY);
    }

    private UISliderBox setupSlider(int x, int y, String key) {
        UISliderBox slider = new UISliderBox(new CGRect(x, y, 160.0f, 10.0f));
        slider.setMinValue(-180.0);
        slider.setMaxValue(180.0);
        slider.setFormatter(currentValue -> new NSString(String.format("%s%.2f\u00b0", key, currentValue)));
        slider.addTarget(this, UIControl.Event.VALUE_CHANGED, SkinWardrobeRotationSetting::updateValue);
        slider.addTarget(this, UIControl.Event.EDITING_DID_END, SkinWardrobeRotationSetting::didUpdateValue);
        this.addSubview(slider);
        return slider;
    }

    private void setupButton(int x, int y, String key, BiConsumer<SkinWardrobeRotationSetting, UIControl> consumer) {
        UIButton button = new UIButton(new CGRect(x, y, 100.0f, 16.0f));
        button.setTitle(this.getDisplayText(key), 7);
        button.setTitleColor(UIColor.WHITE, 7);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, consumer);
        this.addSubview(button);
    }

    public EntityPartView.Part selectedPart() {
        return this.partView.selectedPart();
    }

    public void setSelectedPart(EntityPartView.Part part) {
        this.partView.setSelectedPart(part);
        Rotations rotations = part.getValue(this.entity);
        this.sliderX.setValue(this.getAngle(rotations.func_179415_b()));
        this.sliderY.setValue(this.getAngle(rotations.func_179416_c()));
        this.sliderZ.setValue(this.getAngle(rotations.func_179413_d()));
    }

    private void updateSelectedPart(UIControl control) {
        this.setSelectedPart(this.selectedPart());
    }

    private void updateValue(UIControl button) {
        float x = (float)this.sliderX.value();
        float y = (float)this.sliderY.value();
        float z = (float)this.sliderZ.value();
        this.selectedPart().setValue(this.entity, new Rotations(x, y, z));
    }

    private void didUpdateValue(UIControl button) {
        if (!(this.entity instanceof MannequinEntity)) {
            return;
        }
        CompoundNBT nbt = ((MannequinEntity)this.entity).saveCustomPose();
        UpdateWardrobePacket packet = UpdateWardrobePacket.field(this.wardrobe, UpdateWardrobePacket.Field.MANNEQUIN_POSE, nbt);
        NetworkManager.sendToServer(packet);
    }

    private void randomRotation(UIControl button) {
        HashMap<EntityPartView.Part, Rotations> parts = this.getRandomParts();
        for (EntityPartView.Part part : EntityPartView.Part.values()) {
            Rotations rotations = parts.get((Object)part);
            if (rotations == null) continue;
            part.setValue(this.entity, rotations);
        }
        this.setSelectedPart(this.selectedPart());
        this.didUpdateValue(this.sliderX);
    }

    private void resetRotation(UIControl button) {
        boolean isCtrl = KeyboardManagerImpl.hasControlDown();
        for (EntityPartView.Part part : EntityPartView.Part.values()) {
            if (isCtrl) {
                part.setValue(this.entity, new Rotations(0.0f, 0.0f, 0.0f));
                continue;
            }
            part.setValue(this.entity, part.defaultValue);
        }
        this.setSelectedPart(this.selectedPart());
        this.didUpdateValue(this.sliderX);
    }

    private HashMap<EntityPartView.Part, Rotations> getRandomParts() {
        Random random = new Random();
        if (KeyboardManagerImpl.hasControlDown() && !RANDOMLY_ROTATIONS.isEmpty()) {
            int index = RANDOMLY_INDEX;
            RANDOMLY_INDEX = (RANDOMLY_INDEX + 1) % RANDOMLY_ROTATIONS.size();
            return RANDOMLY_ROTATIONS.get(index);
        }
        HashMap<EntityPartView.Part, Rotations> parts = new HashMap<EntityPartView.Part, Rotations>();
        for (EntityPartView.Part part : EntityPartView.Part.values()) {
            if (part == EntityPartView.Part.BODY) continue;
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            for (int j = 0; j < 3; ++j) {
                x += random.nextFloat() * 60.0f - 30.0f;
                y += random.nextFloat() * 60.0f - 30.0f;
                z += random.nextFloat() * 60.0f - 30.0f;
            }
            parts.put(part, new Rotations(x, y, z));
        }
        return parts;
    }

    private double getAngle(double degree) {
        if (degree <= 180.0) {
            return degree;
        }
        return degree - 360.0;
    }

    private void loadRandomlyRotations() {
        IResourceManager resourceManager = ClientNativeManager.getResourceManager();
        resourceManager.readResources(ModConstants.key("models/entity/mannequin"), s -> s.endsWith(".json"), (location, inputStream) -> {
            IDataPackObject object = StreamUtils.fromPackObject(inputStream);
            if (object == null) {
                return;
            }
            HashMap parts = new HashMap();
            for (EntityPartView.Part part : EntityPartView.Part.values()) {
                object.get(part.name).ifPresent(it -> {
                    float x = it.at(0).floatValue();
                    float y = it.at(1).floatValue();
                    float z = it.at(2).floatValue();
                    parts.put(part, new Rotations(x, y, z));
                });
            }
            RANDOMLY_ROTATIONS.add(parts);
        });
    }
}

