/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.wardrobe;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeBaseSetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeColorSetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeContributorSetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeDisplaySetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeDyeSetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeExtraSetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeInventorySetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeLocationSetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeOutfitSetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeRotationSetting;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeTextureSetting;
import moe.plushie.armourers_workshop.core.client.gui.widget.EntityPreviewView;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.PlayerInventoryView;
import moe.plushie.armourers_workshop.core.client.gui.widget.TabView;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.SkinWardrobeMenu;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModContributors;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeWindow<M extends SkinWardrobeMenu>
extends MenuWindow<M> {
    private final Entity entity;
    private final PlayerEntity operator;
    private final SkinWardrobe wardrobe;
    private final TabView tabView = new TabView(new CGRect(0.0f, 0.0f, 278.0f, 151.0f));

    public SkinWardrobeWindow(M menu, PlayerInventory inventory, NSString title) {
        super(menu, inventory, title);
        this.setFrame(new CGRect(0.0f, 0.0f, 278.0f, 250.0f));
        this.inventoryView.setStyle(PlayerInventoryView.Style.NORMAL);
        this.operator = inventory.field_70458_d;
        this.operator.field_71070_bA = menu;
        this.entity = ((SkinWardrobeMenu)((Object)menu)).getEntity();
        this.wardrobe = ((SkinWardrobeMenu)((Object)menu)).getWardrobe();
    }

    @Override
    public void init() {
        this.setupBackgroundView();
        super.init();
        this.setupTabView();
        this.setupForegroundView();
        this.bringSubviewToFront(this.titleView);
        this.bringSubviewToFront(this.inventoryView);
    }

    private void setupTabView() {
        boolean isPlayer = this.entity instanceof PlayerEntity;
        boolean isMannequin = this.entity instanceof MannequinEntity;
        this.addTab(new SkinWardrobeInventorySetting((SkinWardrobeMenu)this.menu)).setIcon(this.tabIcon(192, 0)).setTarget((Object)SkinWardrobeMenu.Group.SKINS).setActive(!isPlayer || ModConfig.Common.showWardrobeSkins || this.operator.func_184812_l_());
        if (this.wardrobe.getUnlockedSize(SkinSlotType.OUTFIT) != 0) {
            this.addTab(new SkinWardrobeOutfitSetting((SkinWardrobeMenu)this.menu)).setIcon(this.tabIcon(0, 128)).setTarget((Object)SkinWardrobeMenu.Group.OUTFITS).setActive(!isPlayer || ModConfig.Common.showWardrobeOutfits || this.operator.func_184812_l_());
        }
        this.addTab(new SkinWardrobeDisplaySetting(this.wardrobe)).setIcon(this.tabIcon(208, 0)).setActive(!isPlayer || ModConfig.Common.showWardrobeDisplaySettings || this.operator.func_184812_l_());
        this.addTab(new SkinWardrobeColorSetting(this.wardrobe)).setIcon(this.tabIcon(224, 0)).setTarget((Object)SkinWardrobeMenu.Group.COLORS).setActive(!isPlayer || ModConfig.Common.showWardrobeColorSettings || this.operator.func_184812_l_());
        this.addTab(new SkinWardrobeDyeSetting((SkinWardrobeMenu)this.menu)).setIcon(this.tabIcon(240, 0)).setTarget((Object)SkinWardrobeMenu.Group.DYES).setActive(!isPlayer || ModConfig.Common.showWardrobeDyeSetting || this.operator.func_184812_l_());
        if (isPlayer && ModContributors.getCurrentContributor() != null) {
            this.addTab(new SkinWardrobeContributorSetting(this.wardrobe)).setIcon(this.tabIcon(32, 128)).setActive(ModConfig.Common.showWardrobeContributorSetting || this.operator.func_184812_l_());
        }
        if (isMannequin) {
            this.addTab(new SkinWardrobeRotationSetting(this.wardrobe, this.entity)).setIcon(this.tabIcon(80, 0, 8, 150)).setAlignment(1);
            this.addTab(new SkinWardrobeTextureSetting(this.wardrobe)).setIcon(this.tabIcon(128, 0, 8, 150)).setAlignment(1);
            this.addTab(new SkinWardrobeExtraSetting(this.wardrobe)).setIcon(this.tabIcon(144, 0, 8, 150)).setAlignment(1);
            this.addTab(new SkinWardrobeLocationSetting(this.wardrobe, this.entity)).setIcon(this.tabIcon(96, 0, 8, 150)).setAlignment(1);
        }
        this.tabView.addTarget(this, SkinWardrobeWindow::switchTab);
        this.tabView.setSelectedTab(this.tabView.firstActiveTab());
        this.addSubview(this.tabView);
    }

    private void setupBackgroundView() {
        UIView bg1 = new UIView(new CGRect(0.0f, 0.0f, 256.0f, 151.0f));
        UIView bg2 = new UIView(new CGRect(256.0f, 0.0f, 22.0f, 151.0f));
        bg1.setContents(UIImage.of(ModTextures.WARDROBE_1).build());
        bg2.setContents(UIImage.of(ModTextures.WARDROBE_2).build());
        this.tabView.insertViewAtIndex(bg2, 0);
        this.tabView.insertViewAtIndex(bg1, 0);
    }

    private void setupForegroundView() {
        this.tabView.addSubview(this.inventoryView);
        EntityPreviewView entityView = new EntityPreviewView(new CGRect(8.0f, 27.0f, 71.0f, 111.0f));
        entityView.setContents(this.entity);
        this.tabView.addSubview(entityView);
    }

    private void switchTab(TabView.Entry entry) {
        ((SkinWardrobeMenu)this.menu).setGroup(ObjectUtils.safeCast(entry.tag(), SkinWardrobeMenu.Group.class));
        this.inventoryView.setHidden(!((SkinWardrobeMenu)this.menu).shouldRenderInventory());
    }

    private TabView.EntryBuilder addTab(SkinWardrobeBaseSetting contentView) {
        return this.tabView.addContentView(contentView).setTooltip(contentView.getTitle());
    }

    private UIImage tabIcon(int u, int v) {
        return UIImage.of(ModTextures.TAB_ICONS).uv(u, v).fixed(16.0f, 16.0f).build();
    }

    private UIImage tabIcon(int u, int v, int frame, int speed) {
        return UIImage.of(ModTextures.TAB_ICONS).uv(u, v).fixed(16.0f, 16.0f).animation(frame, speed).build();
    }
}

