/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIScreen;
import extensions.com.mojang.blaze3d.systems.RenderSystem.Fix16;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HSBSliderBox
extends UIControl {
    private final Type type;
    private final float[] values = new float[]{1.0f, 1.0f, 1.0f};
    private UIColor hueColor = UIColor.WHITE;
    private UIColor brightnessColor = UIColor.WHITE;
    private UIImage backgroundImage = AppearanceImpl.BUTTON_IMAGE.imageAtIndex(4);
    private boolean isEditing = false;

    public HSBSliderBox(Type type, CGRect frame) {
        super(frame);
        this.type = type;
        this.setValueWithComponents(this.values);
    }

    @Override
    public void mouseDown(UIEvent event) {
        this.beginEditing();
        this.updateValueWithEvent(event);
        super.mouseDown(event);
    }

    @Override
    public void mouseDragged(UIEvent event) {
        this.updateValueWithEvent(event);
        super.mouseDragged(event);
    }

    @Override
    public void mouseUp(UIEvent event) {
        this.updateValueWithEvent(event);
        this.endEditing();
        super.mouseUp(event);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        CGRect bounds = this.bounds();
        CGRect fixedBounds = bounds.insetBy(1.0f, 1.0f, 1.0f, 1.0f);
        context.drawImage(this.backgroundImage, bounds);
        float cx = fixedBounds.x;
        float cy = fixedBounds.y;
        float cw = fixedBounds.width;
        float ch = fixedBounds.height;
        float value = this.values[this.type.ordinal()];
        Fix16.setShaderTexture(RenderSystem.class, 0, ModTextures.HUE);
        if (this.type == Type.SATURATION) {
            context.setBlendColor(this.hueColor);
            context.drawResizableImage(ModTextures.HUE, cx, cy, cw, ch, 0.0f, 176.0f, 256.0f, 20.0f, 256.0f, 256.0f);
            context.setBlendColor(this.brightnessColor);
            context.drawResizableImage(ModTextures.HUE, cx, cy, cw, ch, this.type.u, this.type.v, this.type.texWidth, this.type.texHeight, 256.0f, 256.0f);
            context.setBlendColor(UIColor.WHITE);
        } else {
            context.drawResizableImage(ModTextures.HUE, cx, cy, cw, ch, this.type.u, this.type.v, this.type.texWidth, this.type.texHeight, 256.0f, 256.0f);
        }
        context.addClipRect(UIScreen.convertRectFromView(fixedBounds, this));
        context.drawImage(ModTextures.HUE, (bounds.width - 3.0f) * value - 2.0f, 0.0f, 7.0f, 4.0f, 0.0f, 0.0f, 256.0f, 256.0f);
        context.drawImage(ModTextures.HUE, (bounds.width - 3.0f) * value - 2.0f, bounds.height - 4.0f, 7.0f, 4.0f, 7.0f, 0.0f, 256.0f, 256.0f);
        context.removeClipRect();
    }

    public void setValueWithComponents(float[] values) {
        System.arraycopy(values, 0, this.values, 0, this.values.length);
        if (this.type == Type.SATURATION) {
            this.hueColor = UIColor.getHSBColor(values[0], 1.0f, 1.0f);
            this.brightnessColor = UIColor.getHSBColor(0.0f, 0.0f, values[2]);
        }
    }

    public float getValue() {
        return this.values[this.type.ordinal()];
    }

    private void updateValueWithEvent(UIEvent event) {
        CGPoint point = event.locationInView(this);
        CGRect rect = this.bounds().insetBy(1.0f, 1.0f, 1.0f, 1.0f);
        double value = ((double)point.x - (double)rect.x) / (double)rect.width;
        this.values[this.type.ordinal()] = MathUtils.clamp((float)value, 0.0f, 1.0f);
        this.valueDidChange();
    }

    private void valueDidChange() {
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
    }

    private void beginEditing() {
        this.isEditing = true;
        this.sendEvent(UIControl.Event.EDITING_DID_BEGIN);
    }

    private void endEditing() {
        this.isEditing = false;
        this.sendEvent(UIControl.Event.EDITING_DID_END);
    }

    public static enum Type {
        HUE(0, 236, 256, 20),
        SATURATION(0, 196, 231, 20),
        BRIGHTNESS(0, 216, 256, 20);

        final int u;
        final int v;
        final int texWidth;
        final int texHeight;

        private Type(int u, int v, int texWidth, int texHeight) {
            this.u = u;
            this.v = v;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
        }
    }
}

