/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.TickUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaintColorView
extends UIView {
    private UIColor color = UIColor.WHITE;
    private ISkinPaintType paintType = SkinPaintTypes.NORMAL;

    public PaintColorView(CGRect frame) {
        super(frame);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        int cu = (int)this.paintType.getU();
        int cv = (int)this.paintType.getV();
        int dv = (cv + (int)TickUtils.getPaintTextureOffset()) % 256;
        if (this.paintType != SkinPaintTypes.RAINBOW) {
            context.setBlendColor(this.color);
        }
        CGRect rect = this.bounds();
        context.drawResizableImage(ModTextures.CUBE, 0.0f, 0.0f, rect.width, rect.height, cu, dv, 1.0f, 1.0f, 256.0f, 256.0f);
        if (this.paintType != SkinPaintTypes.RAINBOW) {
            context.setBlendColor(UIColor.WHITE);
        }
    }

    public PaintColor paintColor() {
        return PaintColor.of(this.color.getRGB(), this.paintType);
    }

    public void setPaintColor(IPaintColor color) {
        this.setColor(new UIColor(color.getRGB()));
        this.setPaintType(color.getPaintType());
    }

    public ISkinPaintType paintType() {
        return this.paintType;
    }

    public void setPaintType(ISkinPaintType paintType) {
        this.paintType = paintType;
    }

    public UIColor color() {
        return this.color;
    }

    public void setColor(UIColor color) {
        this.color = color;
    }
}

