/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlotListView<M extends Container>
extends UIView {
    protected final M menu;
    protected final DelegateScreen<M> screen;
    private boolean isReady = false;

    public SlotListView(M menu, PlayerInventory inventory, CGRect frame) {
        super(frame);
        this.menu = menu;
        this.screen = new DelegateScreen<M>(menu, inventory, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, ""));
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        UIWindow window = this.window();
        if (window != null) {
            this.screen.setup(this.convertRectToView(this.bounds(), null), window.bounds());
            this.isReady = true;
        }
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        if (!this.isReady) {
            return;
        }
        int mouseX = (int)context.state().mousePos().getX();
        int mouseY = (int)context.state().mousePos().getY();
        CGPoint offset = this.screen.getContentOffset();
        context.saveGraphicsState();
        context.translateCTM(-offset.getX(), -offset.getY(), 0.0f);
        this.screen.renderInView(this, 400, mouseX, mouseY, context.state().partialTicks(), context);
        context.restoreGraphicsState();
    }

    @Override
    public void mouseDown(UIEvent event) {
        CGPoint pt = this.locationInScreen(event);
        this.screen.func_231044_a_(pt.x, pt.y, event.key());
    }

    @Override
    public void mouseUp(UIEvent event) {
        CGPoint pt = this.locationInScreen(event);
        this.screen.func_231048_c_(pt.x, pt.y, event.key());
    }

    @Override
    public void removeFromSuperview() {
        super.removeFromSuperview();
        this.screen.func_231164_f_();
    }

    public M getMenu() {
        return this.menu;
    }

    private CGPoint locationInScreen(UIEvent event) {
        CGPoint point = event.locationInWindow();
        UIWindow window = this.window();
        if (window != null) {
            CGRect frame = window.frame();
            return new CGPoint(point.x + frame.x, point.y + frame.y);
        }
        return point;
    }

    public static class DelegateScreen<M extends Container>
    extends AbstractMenuScreen<M> {
        private final PlayerInventory inventory;

        public DelegateScreen(M menu, PlayerInventory inventory, ITextComponent component) {
            super(menu, inventory, component);
            this.inventory = inventory;
            this.func_231158_b_(Minecraft.func_71410_x(), 640, 480);
        }

        @Override
        public void func_231175_as__() {
        }

        public void setup(CGRect rect, CGRect bounds) {
            this.setContentSize(new CGSize(rect.width, rect.height));
            this.func_231152_a_(Minecraft.func_71410_x(), (int)bounds.width, (int)bounds.height);
            this.setContentOffset(new CGPoint(rect.x, rect.y));
        }

        @Override
        public void renderLabels(CGGraphicsContext context, int mouseX, int mouseY) {
        }

        public void func_184098_a(Slot slot, int i, int j, ClickType clickType) {
            if (slot != null) {
                this.field_147002_h.func_184996_a(slot.field_75222_d, j, clickType, this.inventory.field_70458_d);
            }
        }
    }
}

