/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.foundation.NSString;
import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeView;
import org.jetbrains.annotations.Nullable;

public class TreeNode {
    private TreeView view;
    private NSString title;
    private boolean folding = false;
    private boolean enabled = false;
    private final ArrayList<TreeNode> children = new ArrayList();

    public TreeNode(NSString title) {
        this.title = title;
    }

    public void setNeedsDisplay() {
        if (this.view != null) {
            this.view.setNeedsDisplay(this);
        }
    }

    public void add(TreeNode node) {
        this.children.add(node);
        node.link(this.view);
        this.setNeedsDisplay();
    }

    public void remove(TreeNode node) {
        this.children.remove(node);
        node.link(null);
        this.setNeedsDisplay();
    }

    public TreeNode nodeAtIndex(int index) {
        return this.children.get(index);
    }

    public Collection<TreeNode> children() {
        return this.children;
    }

    public boolean isFolding() {
        return this.folding;
    }

    public void setFolding(boolean folding) {
        this.folding = folding;
        this.setNeedsDisplay();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public NSString title() {
        return this.title;
    }

    public void setTitle(NSString title) {
        this.title = title;
        this.setNeedsDisplay();
    }

    protected void link(@Nullable TreeView view) {
        this.view = view;
        for (TreeNode node : this.children) {
            node.link(view);
        }
    }
}

