/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.SoundManagerImpl;
import com.apple.library.impl.StateValueImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIScrollView;
import java.util.HashMap;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeNode;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public class TreeView
extends UIScrollView {
    private final TreeNode rootNode = new TreeNode(new NSString("Root"));
    private final HashMap<String, Entry> entries = new HashMap();
    private boolean dirt = true;
    private TreeNode selectedNode = null;

    public TreeView(CGRect frame) {
        super(frame);
        this.rootNode.link(this);
    }

    public TreeNode rootNode() {
        return this.rootNode;
    }

    public void selectNode(TreeNode node) {
        if (this.selectedNode != null) {
            this.deselectNode(this.selectedNode);
        }
        this.selectedNode = node;
        for (Entry entry : this.entries.values()) {
            if (entry.node != node) continue;
            entry.setSelected(true);
        }
    }

    public void deselectNode(TreeNode node) {
        this.selectedNode = null;
        for (Entry entry : this.entries.values()) {
            if (entry.node != node) continue;
            entry.setSelected(false);
        }
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        if (this.dirt) {
            this.buildEntriesIfNeeded();
            this.dirt = false;
        }
    }

    public void setNeedsDisplay(TreeNode node) {
        this.dirt = true;
        this.setNeedsLayout();
    }

    private void buildEntriesIfNeeded() {
        CGRect bounds = this.bounds();
        CGSize itemSize = new CGSize(bounds.width, 11.0f);
        CGSize contentSize = new CGSize(0.0f, 0.0f);
        HashMap<String, Entry> removedEntries = new HashMap<String, Entry>(this.entries);
        this.buildEntry("", 0.0f, 0.0f, itemSize, contentSize, this.rootNode, removedEntries);
        this.setContentSize(contentSize);
        removedEntries.forEach((key, view) -> {
            view.removeFromSuperview();
            this.entries.remove(key);
        });
    }

    private void buildEntry(String key, float x, float y, CGSize itemSize, CGSize contentSize, TreeNode node, HashMap<String, Entry> removedEntries) {
        if (!key.isEmpty()) {
            CGRect rect = new CGRect(0.0f, y, itemSize.width, itemSize.height);
            Entry entry = removedEntries.remove(key);
            if (entry == null) {
                entry = new Entry(rect);
                this.entries.put(key, entry);
                this.addSubview(entry);
            }
            float iconSize = itemSize.height;
            entry.setup(node, rect, x, iconSize);
            entry.setSelected(node == this.selectedNode);
            contentSize.width = itemSize.width;
            contentSize.height = y + itemSize.height;
            x += iconSize;
        }
        if (node.isFolding()) {
            return;
        }
        int index = 0;
        for (TreeNode child : node.children()) {
            String key1 = key + ":" + index++;
            this.buildEntry(key1, x, contentSize.height, itemSize, contentSize, child, removedEntries);
        }
    }

    public static class Entry
    extends UIControl {
        private static final UIImage FOLDING_IMAGE = UIImage.of(ModTextures.LIST).uv(8.0f, 240.0f).build();
        private static final UIImage UNFOLDING_IMAGE = UIImage.of(ModTextures.LIST).uv(8.0f, 248.0f).build();
        private TreeNode node;
        private NSString title;
        private CGRect iconRect = CGRect.ZERO;
        private final StateValueImpl<UIColor> textColor = new StateValueImpl();
        private final StateValueImpl<UIColor> backgroundColor = new StateValueImpl();

        public Entry(CGRect frame) {
            super(frame);
            this.textColor.setValueForState(AppearanceImpl.TREE_TEXT_COLOR, 0);
            this.textColor.setValueForState(AppearanceImpl.TREE_HIGHLIGHTED_TEXT_COLOR, 1);
            this.textColor.setValueForState(AppearanceImpl.TREE_HIGHLIGHTED_TEXT_COLOR, 3);
            this.textColor.setValueForState(AppearanceImpl.TREE_TEXT_COLOR, 2);
            this.backgroundColor.setValueForState(AppearanceImpl.TREE_HIGHLIGHTED_BACKGROUND_COLOR, 1);
            this.backgroundColor.setValueForState(AppearanceImpl.TREE_SELECTED_BACKGROUND_COLOR, 2);
            this.setHighlighted(false);
        }

        public void setup(TreeNode node, CGRect rect, float offset, float size) {
            this.setFrame(rect);
            if (this.node == node) {
                return;
            }
            this.node = node;
            this.title = node.title();
            this.iconRect = new CGRect(offset + 1.0f, 1.0f, 8.0f, 8.0f);
            this.setEnabled(node.isEnabled());
        }

        @Override
        public void render(CGPoint point, CGGraphicsContext context) {
            super.render(point, context);
            if (this.node != null && !this.node.children().isEmpty()) {
                context.setBlendColor(this.textColor.currentValue());
                if (this.node.isFolding()) {
                    context.drawImage(FOLDING_IMAGE, this.iconRect);
                } else {
                    context.drawImage(UNFOLDING_IMAGE, this.iconRect);
                }
                context.setBlendColor(UIColor.WHITE);
            }
            if (this.title != null) {
                context.drawText(this.title, this.iconRect.getMaxX(), 1.0f, null, this.textColor.currentValue(), null);
            }
        }

        @Override
        public void mouseDown(UIEvent event) {
            super.mouseDown(event);
            if (this.node == null) {
                return;
            }
            if (!this.node.children().isEmpty() && this.iconRect.contains(event.locationInView(this))) {
                this.node.setFolding(!this.node.isFolding());
                SoundManagerImpl.click();
                return;
            }
            TreeView treeView = ObjectUtils.safeCast(this.superview(), TreeView.class);
            if (treeView != null) {
                treeView.selectNode(this.node);
                SoundManagerImpl.click();
            }
        }

        @Override
        protected void updateStateIfNeeded() {
            super.updateStateIfNeeded();
            int state = 0;
            if (this.isHighlighted()) {
                state |= 1;
            }
            if (this.isSelected()) {
                state |= 2;
            }
            if (!this.isEnabled()) {
                state |= 4;
            }
            this.textColor.setCurrentState(state);
            this.backgroundColor.setCurrentState(state);
            this.setBackgroundColor(this.backgroundColor.currentValue());
        }
    }
}

