/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import extensions.net.minecraft.world.item.ItemStack.ABI;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemStackProvider;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinArmorType;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.api.skin.ISkinToolType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightContext;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.SkinOverriddenManager;
import moe.plushie.armourers_workshop.core.data.ItemStackProvider;
import moe.plushie.armourers_workshop.core.data.SkinDataStorage;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderData
implements SkinBakery.IBakeListener {
    private final ArrayList<String> missingSkins = new ArrayList();
    private final ArrayList<Entry> armorSkins = new ArrayList();
    private final ArrayList<Entry> itemSkins = new ArrayList();
    private final HashMap<ISkinPaintType, IPaintColor> dyeColors = new HashMap();
    private final HashMap<ISkinPaintType, IPaintColor> lastDyeColors = new HashMap();
    private final NonNullList<ItemStack> lastWardrobeSlots = NonNullList.func_191197_a((int)SkinSlotType.getTotalSize(), (Object)ItemStack.field_190927_a);
    private final ArrayList<ItemStack> lastEquipmentSlots = new ArrayList();
    private final BitSet lastWardrobeFlags = new BitSet();
    private final Ticket loadTicket = Ticket.wardrobe();
    private final IItemStackProvider itemProvider = ItemStackProvider.getInstance();
    private final SkinOverriddenManager overriddenManager = new SkinOverriddenManager();
    private ColorScheme colorScheme = ColorScheme.EMPTY;
    private boolean isRenderExtra = false;
    private boolean isActiveWardrobe = false;
    private boolean isLimitLimbs = false;
    private boolean isListening = false;
    private int version = 0;
    private int lastVersion = Integer.MAX_VALUE;
    public EpicFlightContext epicFlightContext;

    public SkinRenderData(EntityType<?> entityType) {
    }

    @Nullable
    public static SkinRenderData of(@Nullable Entity entity) {
        if (entity != null) {
            return SkinDataStorage.getRenderData(entity).orElse(null);
        }
        return null;
    }

    @Override
    public void didBake(String identifier, BakedSkin bakedSkin) {
        if (this.missingSkins.contains(identifier)) {
            RenderSystem.call(this::invalidateAll);
        }
    }

    public void tick(Entity entity) {
        this.loadEquipmentSlots(entity);
        this.loadWardrobeSlots(entity);
        if (this.lastVersion != this.version) {
            this.reload(entity);
            this.lastVersion = this.version;
        }
    }

    protected void reload(Entity entity) {
        this.invalidateAll();
        this.loadDyeSlots(entity, this::updateDye);
        this.loadHandSlots(entity, this::updateSkin);
        this.loadArmorSlots(entity, this::updateSkin);
        this.loadWardrobeFlags(entity);
        if (this.missingSkins.isEmpty()) {
            if (this.isListening) {
                SkinBakery.getInstance().removeListener(this);
                this.isListening = false;
            }
        } else if (!this.isListening) {
            SkinBakery.getInstance().addListener(this);
            this.isListening = true;
        }
    }

    protected void loadEquipmentSlots(Entity entity) {
        int index = 0;
        for (ItemStack itemStack : this.itemProvider.getAllSlots(entity)) {
            if (index >= this.lastEquipmentSlots.size()) {
                this.lastEquipmentSlots.add(itemStack);
                ++this.version;
            } else if (this.lastVersion != this.version || this.lastEquipmentSlots.get(index) != itemStack) {
                this.lastEquipmentSlots.set(index, itemStack);
                ++this.version;
            }
            ++index;
        }
        while (index < this.lastEquipmentSlots.size()) {
            this.lastEquipmentSlots.remove(index);
        }
    }

    protected void loadWardrobeSlots(Entity entity) {
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe == null) {
            this.isRenderExtra = false;
            this.isActiveWardrobe = false;
            return;
        }
        IInventory inventory = wardrobe.getInventory();
        int size = inventory.func_70302_i_();
        for (int index = 0; index < size; ++index) {
            ItemStack itemStack = inventory.func_70301_a(index);
            if (this.lastVersion == this.version && this.lastWardrobeSlots.get(index) == itemStack) continue;
            this.lastWardrobeSlots.set(index, (Object)itemStack);
            ++this.version;
        }
        BitSet flags = wardrobe.getFlags();
        if (!this.lastWardrobeFlags.equals(flags)) {
            this.lastWardrobeFlags.clear();
            this.lastWardrobeFlags.or(flags);
            ++this.version;
        }
        this.isActiveWardrobe = true;
    }

    protected void invalidateAll() {
        this.lastVersion = Integer.MAX_VALUE;
        this.isLimitLimbs = false;
        this.dyeColors.clear();
        this.missingSkins.clear();
        this.armorSkins.clear();
        this.itemSkins.clear();
        this.overriddenManager.clear();
        this.loadTicket.invalidate();
    }

    private void loadDyeSlots(Entity entity, BiConsumer<ISkinPaintType, ItemStack> consumer) {
        if (!this.isActiveWardrobe) {
            return;
        }
        for (ISkinPaintType paintType2 : SkinSlotType.getSupportedPaintTypes()) {
            ItemStack itemStack = (ItemStack)this.lastWardrobeSlots.get(SkinSlotType.getDyeSlotIndex(paintType2));
            consumer.accept(paintType2, itemStack);
        }
        if (!this.lastDyeColors.equals(this.dyeColors)) {
            this.colorScheme = new ColorScheme();
            this.lastDyeColors.clear();
            this.dyeColors.forEach((paintType, paintColor) -> {
                this.lastDyeColors.put((ISkinPaintType)paintType, (IPaintColor)paintColor);
                this.colorScheme.setColor((ISkinPaintType)paintType, (IPaintColor)paintColor);
            });
        }
    }

    private void loadArmorSlots(Entity entity, ItemConsumer consumer) {
        int i = 0;
        for (ItemStack itemStack : this.itemProvider.getArmorSlots(entity)) {
            consumer.accept(itemStack, i, false);
        }
        if (!this.isActiveWardrobe) {
            return;
        }
        for (SkinSlotType slotType : SkinSlotType.values()) {
            if (slotType == SkinSlotType.DYE) continue;
            int index = slotType.getIndex();
            int size = slotType.getMaxSize();
            for (i = 0; i < size; ++i) {
                consumer.accept((ItemStack)this.lastWardrobeSlots.get(index + i), i, false);
            }
        }
    }

    private void loadHandSlots(Entity entity, ItemConsumer consumer) {
        int i = 0;
        for (ItemStack itemStack : this.itemProvider.getHandSlots(entity)) {
            consumer.accept(itemStack, i, true);
        }
    }

    private void loadWardrobeFlags(Entity entity) {
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe == null) {
            return;
        }
        for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
            if (wardrobe.shouldRenderEquipment(slotType)) {
                this.overriddenManager.removeEquipment(slotType);
                continue;
            }
            this.overriddenManager.addEquipment(slotType);
        }
        this.isRenderExtra = wardrobe.shouldRenderExtra();
    }

    private void updateDye(ISkinPaintType paintType, ItemStack itemStack) {
        IPaintColor paintColor = ColorUtils.getColor(itemStack);
        if (paintColor != null) {
            this.dyeColors.put(paintType, paintColor);
        }
    }

    private void updateSkin(ItemStack itemStack, int slotIndex, boolean isHeld) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return;
        }
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, this.loadTicket);
        if (bakedSkin == null) {
            this.missingSkins.add(descriptor.getIdentifier());
            return;
        }
        ISkinType type = bakedSkin.getType();
        if (type instanceof ISkinArmorType && !isHeld) {
            this.armorSkins.add(new Entry(itemStack, descriptor, bakedSkin, this.colorScheme, slotIndex, false));
            this.loadSkinPart(bakedSkin);
        }
        if (type instanceof ISkinToolType || type == SkinTypes.ITEM) {
            this.itemSkins.add(new Entry(itemStack, descriptor, bakedSkin, this.colorScheme, slotIndex, isHeld));
            this.loadSkinPart(bakedSkin);
        }
    }

    private void loadSkinPart(BakedSkin skin) {
        SkinProperties properties = skin.getSkin().getProperties();
        this.overriddenManager.merge(properties);
        if (!this.isLimitLimbs) {
            this.isLimitLimbs = properties.get(SkinProperty.LIMIT_LEGS_LIMBS);
        }
    }

    private SkinDescriptor getEmbeddedSkin(ItemStack itemStack, boolean replaceSkinItem) {
        if (!replaceSkinItem && ABI.is(itemStack, (Item)ModItems.SKIN.get())) {
            return SkinDescriptor.EMPTY;
        }
        return SkinDescriptor.of(itemStack);
    }

    public Iterable<Entry> getItemSkins(ItemStack itemStack, boolean replaceSkinItem) {
        SkinDescriptor target = this.getEmbeddedSkin(itemStack, replaceSkinItem);
        if (target.isEmpty()) {
            for (Entry entry : this.itemSkins) {
                if (entry.isHeld || !entry.getDescriptor().accept(itemStack)) continue;
                return Collections.singletonList(entry);
            }
        } else {
            for (Entry entry : this.itemSkins) {
                if (!entry.getDescriptor().equals(target)) continue;
                return Collections.singletonList(entry);
            }
        }
        return Collections.emptyList();
    }

    public Iterable<Entry> getArmorSkins() {
        return this.armorSkins;
    }

    public Iterable<Entry> getItemSkins() {
        return this.itemSkins;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public boolean isLimitLimbs() {
        if (!ModConfig.Client.enableSkinLimitLimbs) {
            return false;
        }
        if (this.epicFlightContext != null && !this.epicFlightContext.isLimitLimbs) {
            return false;
        }
        return this.isLimitLimbs;
    }

    public SkinOverriddenManager getOverriddenManager() {
        return this.overriddenManager;
    }

    public boolean shouldRenderExtra() {
        return this.isRenderExtra;
    }

    protected static interface ItemConsumer {
        public void accept(ItemStack var1, int var2, boolean var3);
    }

    public static class Entry {
        protected final ItemStack itemStack;
        protected final SkinDescriptor descriptor;
        protected final BakedSkin bakedSkin;
        protected final ColorScheme bakedScheme;
        protected final boolean isHeld;
        protected final int slotIndex;

        public Entry(ItemStack itemStack, SkinDescriptor descriptor, BakedSkin bakedSkin, ColorScheme entityScheme, int slotIndex, boolean isHeld) {
            this.itemStack = itemStack;
            this.descriptor = descriptor;
            this.bakedSkin = bakedSkin;
            this.bakedScheme = Entry.baking(descriptor.getColorScheme(), entityScheme);
            this.slotIndex = slotIndex;
            this.isHeld = isHeld;
        }

        public static ColorScheme baking(ColorScheme skinScheme, ColorScheme entityScheme) {
            if (skinScheme.isEmpty()) {
                return entityScheme;
            }
            if (entityScheme.isEmpty()) {
                return skinScheme;
            }
            ColorScheme bakedScheme = skinScheme.copy();
            bakedScheme.setReference(entityScheme);
            return bakedScheme;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public BakedSkin getBakedSkin() {
            return this.bakedSkin;
        }

        public ColorScheme getBakedScheme() {
            return this.bakedScheme;
        }

        public SkinDescriptor getDescriptor() {
            return this.descriptor;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }
}

